package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Set of allowed and not allowed actions for a resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowedResourceActions", 
    "notAllowedResourceActions"})
@JsonInclude(Include.NON_NULL)
public class ResourceAction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowedResourceActions")
    protected List<String> allowedResourceActions;

    @JsonProperty("allowedResourceActions@nextLink")
    protected String allowedResourceActionsNextLink;

    @JsonProperty("notAllowedResourceActions")
    protected List<String> notAllowedResourceActions;

    @JsonProperty("notAllowedResourceActions@nextLink")
    protected String notAllowedResourceActionsNextLink;

    protected ResourceAction() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.resourceAction";
    }

    /**
     * <i>“Allowed Actions”</i>
     * 
     * @return property allowedResourceActions
     */
    @Property(name="allowedResourceActions")
    @JsonIgnore
    public CollectionPage<String> getAllowedResourceActions() {
        return new CollectionPage<String>(contextPath, String.class, allowedResourceActions, Optional.ofNullable(allowedResourceActionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Allowed Actions”</i>
     * 
     * @return property allowedResourceActions
     */
    @Property(name="allowedResourceActions")
    @JsonIgnore
    public CollectionPage<String> getAllowedResourceActions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, allowedResourceActions, Optional.ofNullable(allowedResourceActionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Not Allowed Actions.”</i>
     * 
     * @return property notAllowedResourceActions
     */
    @Property(name="notAllowedResourceActions")
    @JsonIgnore
    public CollectionPage<String> getNotAllowedResourceActions() {
        return new CollectionPage<String>(contextPath, String.class, notAllowedResourceActions, Optional.ofNullable(notAllowedResourceActionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Not Allowed Actions.”</i>
     * 
     * @return property notAllowedResourceActions
     */
    @Property(name="notAllowedResourceActions")
    @JsonIgnore
    public CollectionPage<String> getNotAllowedResourceActions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, notAllowedResourceActions, Optional.ofNullable(notAllowedResourceActionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> allowedResourceActions;
        private String allowedResourceActionsNextLink;
        private List<String> notAllowedResourceActions;
        private String notAllowedResourceActionsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Allowed Actions”</i>
         * 
         * @param allowedResourceActions
         *            value of {@code allowedResourceActions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedResourceActions(List<String> allowedResourceActions) {
            this.allowedResourceActions = allowedResourceActions;
            this.changedFields = changedFields.add("allowedResourceActions");
            return this;
        }

        /**
         * <i>“Allowed Actions”</i>
         * 
         * @param allowedResourceActions
         *            value of {@code allowedResourceActions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedResourceActions(String... allowedResourceActions) {
            return allowedResourceActions(Arrays.asList(allowedResourceActions));
        }

        /**
         * <i>“Allowed Actions”</i>
         * 
         * @param allowedResourceActionsNextLink
         *            value of {@code allowedResourceActions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedResourceActionsNextLink(String allowedResourceActionsNextLink) {
            this.allowedResourceActionsNextLink = allowedResourceActionsNextLink;
            this.changedFields = changedFields.add("allowedResourceActions");
            return this;
        }

        /**
         * <i>“Not Allowed Actions.”</i>
         * 
         * @param notAllowedResourceActions
         *            value of {@code notAllowedResourceActions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notAllowedResourceActions(List<String> notAllowedResourceActions) {
            this.notAllowedResourceActions = notAllowedResourceActions;
            this.changedFields = changedFields.add("notAllowedResourceActions");
            return this;
        }

        /**
         * <i>“Not Allowed Actions.”</i>
         * 
         * @param notAllowedResourceActions
         *            value of {@code notAllowedResourceActions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notAllowedResourceActions(String... notAllowedResourceActions) {
            return notAllowedResourceActions(Arrays.asList(notAllowedResourceActions));
        }

        /**
         * <i>“Not Allowed Actions.”</i>
         * 
         * @param notAllowedResourceActionsNextLink
         *            value of {@code notAllowedResourceActions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notAllowedResourceActionsNextLink(String notAllowedResourceActionsNextLink) {
            this.notAllowedResourceActionsNextLink = notAllowedResourceActionsNextLink;
            this.changedFields = changedFields.add("notAllowedResourceActions");
            return this;
        }

        public ResourceAction build() {
            ResourceAction _x = new ResourceAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.resourceAction";
            _x.allowedResourceActions = allowedResourceActions;
            _x.allowedResourceActionsNextLink = allowedResourceActionsNextLink;
            _x.notAllowedResourceActions = notAllowedResourceActions;
            _x.notAllowedResourceActionsNextLink = notAllowedResourceActionsNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResourceAction[");
        b.append("allowedResourceActions=");
        b.append(this.allowedResourceActions);
        b.append(", ");
        b.append("notAllowedResourceActions=");
        b.append(this.notAllowedResourceActions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
