package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ActionState;


/**
 * <i>“Reset passcode action result”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "passcode", 
    "errorCode"})
@JsonInclude(Include.NON_NULL)
public class ResetPasscodeActionResult extends DeviceActionResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("passcode")
    protected String passcode;

    @JsonProperty("errorCode")
    protected Integer errorCode;

    protected ResetPasscodeActionResult() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.resetPasscodeActionResult";
    }

    /**
     * <i>“Newly generated passcode for the device”</i>
     * 
     * @return property passcode
     */
    @Property(name="passcode")
    @JsonIgnore
    public Optional<String> getPasscode() {
        return Optional.ofNullable(passcode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code passcode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Newly generated passcode for the device”</i>
     * 
     * @param passcode
     *            new value of {@code passcode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passcode} field changed
     */
    public ResetPasscodeActionResult withPasscode(String passcode) {
        ResetPasscodeActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resetPasscodeActionResult");
        _x.passcode = passcode;
        return _x;
    }

    /**
     * <i>“RotateBitLockerKeys action error code. Valid values 0 to 2147483647”</i>
     * 
     * @return property errorCode
     */
    @Property(name="errorCode")
    @JsonIgnore
    public Optional<Integer> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“RotateBitLockerKeys action error code. Valid values 0 to 2147483647”</i>
     * 
     * @param errorCode
     *            new value of {@code errorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCode} field changed
     */
    public ResetPasscodeActionResult withErrorCode(Integer errorCode) {
        ResetPasscodeActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resetPasscodeActionResult");
        _x.errorCode = errorCode;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderResetPasscodeActionResult() {
        return new Builder();
    }

    public static final class Builder {
        private String actionName;
        private ActionState actionState;
        private OffsetDateTime startDateTime;
        private OffsetDateTime lastUpdatedDateTime;
        private String passcode;
        private Integer errorCode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            this.changedFields = changedFields.add("actionName");
            return this;
        }

        public Builder actionState(ActionState actionState) {
            this.actionState = actionState;
            this.changedFields = changedFields.add("actionState");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        /**
         * <i>“Newly generated passcode for the device”</i>
         * 
         * @param passcode
         *            value of {@code passcode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passcode(String passcode) {
            this.passcode = passcode;
            this.changedFields = changedFields.add("passcode");
            return this;
        }

        /**
         * <i>“RotateBitLockerKeys action error code. Valid values 0 to 2147483647”</i>
         * 
         * @param errorCode
         *            value of {@code errorCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        public ResetPasscodeActionResult build() {
            ResetPasscodeActionResult _x = new ResetPasscodeActionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.resetPasscodeActionResult";
            _x.actionName = actionName;
            _x.actionState = actionState;
            _x.startDateTime = startDateTime;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.passcode = passcode;
            _x.errorCode = errorCode;
            return _x;
        }
    }

    private ResetPasscodeActionResult _copy() {
        ResetPasscodeActionResult _x = new ResetPasscodeActionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.actionName = actionName;
        _x.actionState = actionState;
        _x.startDateTime = startDateTime;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.passcode = passcode;
        _x.errorCode = errorCode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResetPasscodeActionResult[");
        b.append("actionName=");
        b.append(this.actionName);
        b.append(", ");
        b.append("actionState=");
        b.append(this.actionState);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("passcode=");
        b.append(this.passcode);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
