package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Device Configuration profile History reports.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "content"})
@JsonInclude(Include.NON_NULL)
public class Report implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("content")
    protected String content;

    protected Report() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.report";
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<StreamProvider> getContent() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "content", content);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code content} property.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderSingleCall> putContent() {
        return putContent(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code content} property.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderChunked> putChunkedContent() {
        return putContent(UploadStrategy.chunked());
    }

    @Property(name="content")
    public <T extends StreamUploader<T>> Optional<T> putContent(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("content"), this, "content");
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String content;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Report build() {
            Report _x = new Report();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.report";
            _x.content = content;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Report[");
        b.append("content=");
        b.append(this.content);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
