package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "newName", 
    "oldName"})
@JsonInclude(Include.NON_NULL)
public class RenameAction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("newName")
    protected String newName;

    @JsonProperty("oldName")
    protected String oldName;

    protected RenameAction() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.renameAction";
    }

    @Property(name="newName")
    @JsonIgnore
    public Optional<String> getNewName() {
        return Optional.ofNullable(newName);
    }

    public RenameAction withNewName(String newName) {
        RenameAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.renameAction");
        _x.newName = newName;
        return _x;
    }

    @Property(name="oldName")
    @JsonIgnore
    public Optional<String> getOldName() {
        return Optional.ofNullable(oldName);
    }

    public RenameAction withOldName(String oldName) {
        RenameAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.renameAction");
        _x.oldName = oldName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String newName;
        private String oldName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder newName(String newName) {
            this.newName = newName;
            this.changedFields = changedFields.add("newName");
            return this;
        }

        public Builder oldName(String oldName) {
            this.oldName = oldName;
            this.changedFields = changedFields.add("oldName");
            return this;
        }

        public RenameAction build() {
            RenameAction _x = new RenameAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.renameAction";
            _x.newName = newName;
            _x.oldName = oldName;
            return _x;
        }
    }

    private RenameAction _copy() {
        RenameAction _x = new RenameAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.newName = newName;
        _x.oldName = oldName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RenameAction[");
        b.append("newName=");
        b.append(this.newName);
        b.append(", ");
        b.append("oldName=");
        b.append(this.oldName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
