package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "uiElementNames"})
@JsonInclude(Include.NON_NULL)
public class RemoveContentHeaderAction extends InformationProtectionAction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("uiElementNames")
    protected List<String> uiElementNames;

    @JsonProperty("uiElementNames@nextLink")
    protected String uiElementNamesNextLink;

    protected RemoveContentHeaderAction() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.removeContentHeaderAction";
    }

    @Property(name="uiElementNames")
    @JsonIgnore
    public CollectionPage<String> getUiElementNames() {
        return new CollectionPage<String>(contextPath, String.class, uiElementNames, Optional.ofNullable(uiElementNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="uiElementNames")
    @JsonIgnore
    public CollectionPage<String> getUiElementNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, uiElementNames, Optional.ofNullable(uiElementNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRemoveContentHeaderAction() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> uiElementNames;
        private String uiElementNamesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder uiElementNames(List<String> uiElementNames) {
            this.uiElementNames = uiElementNames;
            this.changedFields = changedFields.add("uiElementNames");
            return this;
        }

        public Builder uiElementNames(String... uiElementNames) {
            return uiElementNames(Arrays.asList(uiElementNames));
        }

        public Builder uiElementNamesNextLink(String uiElementNamesNextLink) {
            this.uiElementNamesNextLink = uiElementNamesNextLink;
            this.changedFields = changedFields.add("uiElementNames");
            return this;
        }

        public RemoveContentHeaderAction build() {
            RemoveContentHeaderAction _x = new RemoveContentHeaderAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.removeContentHeaderAction";
            _x.uiElementNames = uiElementNames;
            _x.uiElementNamesNextLink = uiElementNamesNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RemoveContentHeaderAction[");
        b.append("uiElementNames=");
        b.append(this.uiElementNames);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
