package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ActionState;


/**
 * <i>“Lock action result with a pin to unlock”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "unlockPin"})
@JsonInclude(Include.NON_NULL)
public class RemoteLockActionResult extends DeviceActionResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("unlockPin")
    protected String unlockPin;

    protected RemoteLockActionResult() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.remoteLockActionResult";
    }

    /**
     * <i>“Pin to unlock the client”</i>
     * 
     * @return property unlockPin
     */
    @Property(name="unlockPin")
    @JsonIgnore
    public Optional<String> getUnlockPin() {
        return Optional.ofNullable(unlockPin);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code unlockPin} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Pin to unlock the client”</i>
     * 
     * @param unlockPin
     *            new value of {@code unlockPin} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unlockPin} field changed
     */
    public RemoteLockActionResult withUnlockPin(String unlockPin) {
        RemoteLockActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteLockActionResult");
        _x.unlockPin = unlockPin;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRemoteLockActionResult() {
        return new Builder();
    }

    public static final class Builder {
        private String actionName;
        private ActionState actionState;
        private OffsetDateTime startDateTime;
        private OffsetDateTime lastUpdatedDateTime;
        private String unlockPin;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            this.changedFields = changedFields.add("actionName");
            return this;
        }

        public Builder actionState(ActionState actionState) {
            this.actionState = actionState;
            this.changedFields = changedFields.add("actionState");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        /**
         * <i>“Pin to unlock the client”</i>
         * 
         * @param unlockPin
         *            value of {@code unlockPin} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unlockPin(String unlockPin) {
            this.unlockPin = unlockPin;
            this.changedFields = changedFields.add("unlockPin");
            return this;
        }

        public RemoteLockActionResult build() {
            RemoteLockActionResult _x = new RemoteLockActionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.remoteLockActionResult";
            _x.actionName = actionName;
            _x.actionState = actionState;
            _x.startDateTime = startDateTime;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.unlockPin = unlockPin;
            return _x;
        }
    }

    private RemoteLockActionResult _copy() {
        RemoteLockActionResult _x = new RemoteLockActionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.actionName = actionName;
        _x.actionState = actionState;
        _x.startDateTime = startDateTime;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.unlockPin = unlockPin;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RemoteLockActionResult[");
        b.append("actionName=");
        b.append(this.actionName);
        b.append(", ");
        b.append("actionState=");
        b.append(this.actionState);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("unlockPin=");
        b.append(this.unlockPin);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
