package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "createdBy", 
    "createdDateTime", 
    "file", 
    "fileSystemInfo", 
    "folder", 
    "id", 
    "image", 
    "lastModifiedBy", 
    "lastModifiedDateTime", 
    "name", 
    "package", 
    "parentReference", 
    "shared", 
    "sharepointIds", 
    "size", 
    "specialFolder", 
    "video", 
    "webDavUrl", 
    "webUrl"})
@JsonInclude(Include.NON_NULL)
public class RemoteItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("file")
    protected File file;

    @JsonProperty("fileSystemInfo")
    protected FileSystemInfo fileSystemInfo;

    @JsonProperty("folder")
    protected Folder folder;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("image")
    protected Image image;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("package")
    protected Package package_;

    @JsonProperty("parentReference")
    protected ItemReference parentReference;

    @JsonProperty("shared")
    protected Shared shared;

    @JsonProperty("sharepointIds")
    protected SharepointIds sharepointIds;

    @JsonProperty("size")
    protected Long size;

    @JsonProperty("specialFolder")
    protected SpecialFolder specialFolder;

    @JsonProperty("video")
    protected Video video;

    @JsonProperty("webDavUrl")
    protected String webDavUrl;

    @JsonProperty("webUrl")
    protected String webUrl;

    protected RemoteItem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.remoteItem";
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public RemoteItem withCreatedBy(IdentitySet createdBy) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public RemoteItem withCreatedDateTime(OffsetDateTime createdDateTime) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="file")
    @JsonIgnore
    public Optional<File> getFile() {
        return Optional.ofNullable(file);
    }

    public RemoteItem withFile(File file) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.file = file;
        return _x;
    }

    @Property(name="fileSystemInfo")
    @JsonIgnore
    public Optional<FileSystemInfo> getFileSystemInfo() {
        return Optional.ofNullable(fileSystemInfo);
    }

    public RemoteItem withFileSystemInfo(FileSystemInfo fileSystemInfo) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.fileSystemInfo = fileSystemInfo;
        return _x;
    }

    @Property(name="folder")
    @JsonIgnore
    public Optional<Folder> getFolder() {
        return Optional.ofNullable(folder);
    }

    public RemoteItem withFolder(Folder folder) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.folder = folder;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public RemoteItem withId(String id) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.id = id;
        return _x;
    }

    @Property(name="image")
    @JsonIgnore
    public Optional<Image> getImage() {
        return Optional.ofNullable(image);
    }

    public RemoteItem withImage(Image image) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.image = image;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public RemoteItem withLastModifiedBy(IdentitySet lastModifiedBy) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public RemoteItem withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public RemoteItem withName(String name) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.name = name;
        return _x;
    }

    @Property(name="package")
    @JsonIgnore
    public Optional<Package> getPackage() {
        return Optional.ofNullable(package_);
    }

    public RemoteItem withPackage(Package package_) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.package_ = package_;
        return _x;
    }

    @Property(name="parentReference")
    @JsonIgnore
    public Optional<ItemReference> getParentReference() {
        return Optional.ofNullable(parentReference);
    }

    public RemoteItem withParentReference(ItemReference parentReference) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.parentReference = parentReference;
        return _x;
    }

    @Property(name="shared")
    @JsonIgnore
    public Optional<Shared> getShared() {
        return Optional.ofNullable(shared);
    }

    public RemoteItem withShared(Shared shared) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.shared = shared;
        return _x;
    }

    @Property(name="sharepointIds")
    @JsonIgnore
    public Optional<SharepointIds> getSharepointIds() {
        return Optional.ofNullable(sharepointIds);
    }

    public RemoteItem withSharepointIds(SharepointIds sharepointIds) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.sharepointIds = sharepointIds;
        return _x;
    }

    @Property(name="size")
    @JsonIgnore
    public Optional<Long> getSize() {
        return Optional.ofNullable(size);
    }

    public RemoteItem withSize(Long size) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.size = size;
        return _x;
    }

    @Property(name="specialFolder")
    @JsonIgnore
    public Optional<SpecialFolder> getSpecialFolder() {
        return Optional.ofNullable(specialFolder);
    }

    public RemoteItem withSpecialFolder(SpecialFolder specialFolder) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.specialFolder = specialFolder;
        return _x;
    }

    @Property(name="video")
    @JsonIgnore
    public Optional<Video> getVideo() {
        return Optional.ofNullable(video);
    }

    public RemoteItem withVideo(Video video) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.video = video;
        return _x;
    }

    @Property(name="webDavUrl")
    @JsonIgnore
    public Optional<String> getWebDavUrl() {
        return Optional.ofNullable(webDavUrl);
    }

    public RemoteItem withWebDavUrl(String webDavUrl) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.webDavUrl = webDavUrl;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public RemoteItem withWebUrl(String webUrl) {
        RemoteItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteItem");
        _x.webUrl = webUrl;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private File file;
        private FileSystemInfo fileSystemInfo;
        private Folder folder;
        private String id;
        private Image image;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private String name;
        private Package package_;
        private ItemReference parentReference;
        private Shared shared;
        private SharepointIds sharepointIds;
        private Long size;
        private SpecialFolder specialFolder;
        private Video video;
        private String webDavUrl;
        private String webUrl;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder file(File file) {
            this.file = file;
            this.changedFields = changedFields.add("file");
            return this;
        }

        public Builder fileSystemInfo(FileSystemInfo fileSystemInfo) {
            this.fileSystemInfo = fileSystemInfo;
            this.changedFields = changedFields.add("fileSystemInfo");
            return this;
        }

        public Builder folder(Folder folder) {
            this.folder = folder;
            this.changedFields = changedFields.add("folder");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder image(Image image) {
            this.image = image;
            this.changedFields = changedFields.add("image");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder package_(Package package_) {
            this.package_ = package_;
            this.changedFields = changedFields.add("package");
            return this;
        }

        public Builder parentReference(ItemReference parentReference) {
            this.parentReference = parentReference;
            this.changedFields = changedFields.add("parentReference");
            return this;
        }

        public Builder shared(Shared shared) {
            this.shared = shared;
            this.changedFields = changedFields.add("shared");
            return this;
        }

        public Builder sharepointIds(SharepointIds sharepointIds) {
            this.sharepointIds = sharepointIds;
            this.changedFields = changedFields.add("sharepointIds");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public Builder specialFolder(SpecialFolder specialFolder) {
            this.specialFolder = specialFolder;
            this.changedFields = changedFields.add("specialFolder");
            return this;
        }

        public Builder video(Video video) {
            this.video = video;
            this.changedFields = changedFields.add("video");
            return this;
        }

        public Builder webDavUrl(String webDavUrl) {
            this.webDavUrl = webDavUrl;
            this.changedFields = changedFields.add("webDavUrl");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public RemoteItem build() {
            RemoteItem _x = new RemoteItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.remoteItem";
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.file = file;
            _x.fileSystemInfo = fileSystemInfo;
            _x.folder = folder;
            _x.id = id;
            _x.image = image;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.name = name;
            _x.package_ = package_;
            _x.parentReference = parentReference;
            _x.shared = shared;
            _x.sharepointIds = sharepointIds;
            _x.size = size;
            _x.specialFolder = specialFolder;
            _x.video = video;
            _x.webDavUrl = webDavUrl;
            _x.webUrl = webUrl;
            return _x;
        }
    }

    private RemoteItem _copy() {
        RemoteItem _x = new RemoteItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.file = file;
        _x.fileSystemInfo = fileSystemInfo;
        _x.folder = folder;
        _x.id = id;
        _x.image = image;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.name = name;
        _x.package_ = package_;
        _x.parentReference = parentReference;
        _x.shared = shared;
        _x.sharepointIds = sharepointIds;
        _x.size = size;
        _x.specialFolder = specialFolder;
        _x.video = video;
        _x.webDavUrl = webDavUrl;
        _x.webUrl = webUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RemoteItem[");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("file=");
        b.append(this.file);
        b.append(", ");
        b.append("fileSystemInfo=");
        b.append(this.fileSystemInfo);
        b.append(", ");
        b.append("folder=");
        b.append(this.folder);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("image=");
        b.append(this.image);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("package=");
        b.append(this.package_);
        b.append(", ");
        b.append("parentReference=");
        b.append(this.parentReference);
        b.append(", ");
        b.append("shared=");
        b.append(this.shared);
        b.append(", ");
        b.append("sharepointIds=");
        b.append(this.sharepointIds);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("specialFolder=");
        b.append(this.specialFolder);
        b.append(", ");
        b.append("video=");
        b.append(this.video);
        b.append(", ");
        b.append("webDavUrl=");
        b.append(this.webDavUrl);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
