package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "eventId", 
    "eventStartTime", 
    "eventEndTime", 
    "changeKey", 
    "eventSubject", 
    "eventLocation", 
    "eventWebLink", 
    "reminderFireTime"})
@JsonInclude(Include.NON_NULL)
public class Reminder implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("eventId")
    protected String eventId;

    @JsonProperty("eventStartTime")
    protected DateTimeTimeZone eventStartTime;

    @JsonProperty("eventEndTime")
    protected DateTimeTimeZone eventEndTime;

    @JsonProperty("changeKey")
    protected String changeKey;

    @JsonProperty("eventSubject")
    protected String eventSubject;

    @JsonProperty("eventLocation")
    protected Location eventLocation;

    @JsonProperty("eventWebLink")
    protected String eventWebLink;

    @JsonProperty("reminderFireTime")
    protected DateTimeTimeZone reminderFireTime;

    protected Reminder() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.reminder";
    }

    @Property(name="eventId")
    @JsonIgnore
    public Optional<String> getEventId() {
        return Optional.ofNullable(eventId);
    }

    public Reminder withEventId(String eventId) {
        Reminder _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reminder");
        _x.eventId = eventId;
        return _x;
    }

    @Property(name="eventStartTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getEventStartTime() {
        return Optional.ofNullable(eventStartTime);
    }

    public Reminder withEventStartTime(DateTimeTimeZone eventStartTime) {
        Reminder _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reminder");
        _x.eventStartTime = eventStartTime;
        return _x;
    }

    @Property(name="eventEndTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getEventEndTime() {
        return Optional.ofNullable(eventEndTime);
    }

    public Reminder withEventEndTime(DateTimeTimeZone eventEndTime) {
        Reminder _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reminder");
        _x.eventEndTime = eventEndTime;
        return _x;
    }

    @Property(name="changeKey")
    @JsonIgnore
    public Optional<String> getChangeKey() {
        return Optional.ofNullable(changeKey);
    }

    public Reminder withChangeKey(String changeKey) {
        Reminder _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reminder");
        _x.changeKey = changeKey;
        return _x;
    }

    @Property(name="eventSubject")
    @JsonIgnore
    public Optional<String> getEventSubject() {
        return Optional.ofNullable(eventSubject);
    }

    public Reminder withEventSubject(String eventSubject) {
        Reminder _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reminder");
        _x.eventSubject = eventSubject;
        return _x;
    }

    @Property(name="eventLocation")
    @JsonIgnore
    public Optional<Location> getEventLocation() {
        return Optional.ofNullable(eventLocation);
    }

    public Reminder withEventLocation(Location eventLocation) {
        Reminder _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reminder");
        _x.eventLocation = eventLocation;
        return _x;
    }

    @Property(name="eventWebLink")
    @JsonIgnore
    public Optional<String> getEventWebLink() {
        return Optional.ofNullable(eventWebLink);
    }

    public Reminder withEventWebLink(String eventWebLink) {
        Reminder _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reminder");
        _x.eventWebLink = eventWebLink;
        return _x;
    }

    @Property(name="reminderFireTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getReminderFireTime() {
        return Optional.ofNullable(reminderFireTime);
    }

    public Reminder withReminderFireTime(DateTimeTimeZone reminderFireTime) {
        Reminder _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.reminder");
        _x.reminderFireTime = reminderFireTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String eventId;
        private DateTimeTimeZone eventStartTime;
        private DateTimeTimeZone eventEndTime;
        private String changeKey;
        private String eventSubject;
        private Location eventLocation;
        private String eventWebLink;
        private DateTimeTimeZone reminderFireTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder eventId(String eventId) {
            this.eventId = eventId;
            this.changedFields = changedFields.add("eventId");
            return this;
        }

        public Builder eventStartTime(DateTimeTimeZone eventStartTime) {
            this.eventStartTime = eventStartTime;
            this.changedFields = changedFields.add("eventStartTime");
            return this;
        }

        public Builder eventEndTime(DateTimeTimeZone eventEndTime) {
            this.eventEndTime = eventEndTime;
            this.changedFields = changedFields.add("eventEndTime");
            return this;
        }

        public Builder changeKey(String changeKey) {
            this.changeKey = changeKey;
            this.changedFields = changedFields.add("changeKey");
            return this;
        }

        public Builder eventSubject(String eventSubject) {
            this.eventSubject = eventSubject;
            this.changedFields = changedFields.add("eventSubject");
            return this;
        }

        public Builder eventLocation(Location eventLocation) {
            this.eventLocation = eventLocation;
            this.changedFields = changedFields.add("eventLocation");
            return this;
        }

        public Builder eventWebLink(String eventWebLink) {
            this.eventWebLink = eventWebLink;
            this.changedFields = changedFields.add("eventWebLink");
            return this;
        }

        public Builder reminderFireTime(DateTimeTimeZone reminderFireTime) {
            this.reminderFireTime = reminderFireTime;
            this.changedFields = changedFields.add("reminderFireTime");
            return this;
        }

        public Reminder build() {
            Reminder _x = new Reminder();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.reminder";
            _x.eventId = eventId;
            _x.eventStartTime = eventStartTime;
            _x.eventEndTime = eventEndTime;
            _x.changeKey = changeKey;
            _x.eventSubject = eventSubject;
            _x.eventLocation = eventLocation;
            _x.eventWebLink = eventWebLink;
            _x.reminderFireTime = reminderFireTime;
            return _x;
        }
    }

    private Reminder _copy() {
        Reminder _x = new Reminder();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.eventId = eventId;
        _x.eventStartTime = eventStartTime;
        _x.eventEndTime = eventEndTime;
        _x.changeKey = changeKey;
        _x.eventSubject = eventSubject;
        _x.eventLocation = eventLocation;
        _x.eventWebLink = eventWebLink;
        _x.reminderFireTime = reminderFireTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Reminder[");
        b.append("eventId=");
        b.append(this.eventId);
        b.append(", ");
        b.append("eventStartTime=");
        b.append(this.eventStartTime);
        b.append(", ");
        b.append("eventEndTime=");
        b.append(this.eventEndTime);
        b.append(", ");
        b.append("changeKey=");
        b.append(this.changeKey);
        b.append(", ");
        b.append("eventSubject=");
        b.append(this.eventSubject);
        b.append(", ");
        b.append("eventLocation=");
        b.append(this.eventLocation);
        b.append(", ");
        b.append("eventWebLink=");
        b.append(this.eventWebLink);
        b.append(", ");
        b.append("reminderFireTime=");
        b.append(this.reminderFireTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
