package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.PersonRelationship;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "relationship", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class RelatedPerson implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("relationship")
    protected PersonRelationship relationship;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected RelatedPerson() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.relatedPerson";
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public RelatedPerson withDisplayName(String displayName) {
        RelatedPerson _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relatedPerson");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="relationship")
    @JsonIgnore
    public Optional<PersonRelationship> getRelationship() {
        return Optional.ofNullable(relationship);
    }

    public RelatedPerson withRelationship(PersonRelationship relationship) {
        RelatedPerson _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relatedPerson");
        _x.relationship = relationship;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public RelatedPerson withUserPrincipalName(String userPrincipalName) {
        RelatedPerson _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relatedPerson");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private PersonRelationship relationship;
        private String userPrincipalName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder relationship(PersonRelationship relationship) {
            this.relationship = relationship;
            this.changedFields = changedFields.add("relationship");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public RelatedPerson build() {
            RelatedPerson _x = new RelatedPerson();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.relatedPerson";
            _x.displayName = displayName;
            _x.relationship = relationship;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    private RelatedPerson _copy() {
        RelatedPerson _x = new RelatedPerson();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.relationship = relationship;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RelatedPerson[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("relationship=");
        b.append(this.relationship);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
