package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.AuthenticationMethodTargetType;

@JsonPropertyOrder({
    "@odata.type", 
    "targetType", 
    "id", 
    "minAuthMethodsToRegister", 
    "minAuthMethodsToReset"})
@JsonInclude(Include.NON_NULL)
public class RegistrationAndResetTarget implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("targetType")
    protected AuthenticationMethodTargetType targetType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("minAuthMethodsToRegister")
    protected Integer minAuthMethodsToRegister;

    @JsonProperty("minAuthMethodsToReset")
    protected Integer minAuthMethodsToReset;

    protected RegistrationAndResetTarget() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.registrationAndResetTarget";
    }

    @Property(name="targetType")
    @JsonIgnore
    public Optional<AuthenticationMethodTargetType> getTargetType() {
        return Optional.ofNullable(targetType);
    }

    public RegistrationAndResetTarget withTargetType(AuthenticationMethodTargetType targetType) {
        RegistrationAndResetTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.registrationAndResetTarget");
        _x.targetType = targetType;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public RegistrationAndResetTarget withId(String id) {
        RegistrationAndResetTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.registrationAndResetTarget");
        _x.id = id;
        return _x;
    }

    @Property(name="minAuthMethodsToRegister")
    @JsonIgnore
    public Optional<Integer> getMinAuthMethodsToRegister() {
        return Optional.ofNullable(minAuthMethodsToRegister);
    }

    public RegistrationAndResetTarget withMinAuthMethodsToRegister(Integer minAuthMethodsToRegister) {
        RegistrationAndResetTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.registrationAndResetTarget");
        _x.minAuthMethodsToRegister = minAuthMethodsToRegister;
        return _x;
    }

    @Property(name="minAuthMethodsToReset")
    @JsonIgnore
    public Optional<Integer> getMinAuthMethodsToReset() {
        return Optional.ofNullable(minAuthMethodsToReset);
    }

    public RegistrationAndResetTarget withMinAuthMethodsToReset(Integer minAuthMethodsToReset) {
        RegistrationAndResetTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.registrationAndResetTarget");
        _x.minAuthMethodsToReset = minAuthMethodsToReset;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AuthenticationMethodTargetType targetType;
        private String id;
        private Integer minAuthMethodsToRegister;
        private Integer minAuthMethodsToReset;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder targetType(AuthenticationMethodTargetType targetType) {
            this.targetType = targetType;
            this.changedFields = changedFields.add("targetType");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder minAuthMethodsToRegister(Integer minAuthMethodsToRegister) {
            this.minAuthMethodsToRegister = minAuthMethodsToRegister;
            this.changedFields = changedFields.add("minAuthMethodsToRegister");
            return this;
        }

        public Builder minAuthMethodsToReset(Integer minAuthMethodsToReset) {
            this.minAuthMethodsToReset = minAuthMethodsToReset;
            this.changedFields = changedFields.add("minAuthMethodsToReset");
            return this;
        }

        public RegistrationAndResetTarget build() {
            RegistrationAndResetTarget _x = new RegistrationAndResetTarget();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.registrationAndResetTarget";
            _x.targetType = targetType;
            _x.id = id;
            _x.minAuthMethodsToRegister = minAuthMethodsToRegister;
            _x.minAuthMethodsToReset = minAuthMethodsToReset;
            return _x;
        }
    }

    private RegistrationAndResetTarget _copy() {
        RegistrationAndResetTarget _x = new RegistrationAndResetTarget();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.targetType = targetType;
        _x.id = id;
        _x.minAuthMethodsToRegister = minAuthMethodsToRegister;
        _x.minAuthMethodsToReset = minAuthMethodsToReset;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RegistrationAndResetTarget[");
        b.append("targetType=");
        b.append(this.targetType);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("minAuthMethodsToRegister=");
        b.append(this.minAuthMethodsToRegister);
        b.append(", ");
        b.append("minAuthMethodsToReset=");
        b.append(this.minAuthMethodsToReset);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
