package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "referencedObjectName", 
    "referencedProperty"})
@JsonInclude(Include.NON_NULL)
public class ReferencedObject implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("referencedObjectName")
    protected String referencedObjectName;

    @JsonProperty("referencedProperty")
    protected String referencedProperty;

    protected ReferencedObject() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.referencedObject";
    }

    @Property(name="referencedObjectName")
    @JsonIgnore
    public Optional<String> getReferencedObjectName() {
        return Optional.ofNullable(referencedObjectName);
    }

    public ReferencedObject withReferencedObjectName(String referencedObjectName) {
        ReferencedObject _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.referencedObject");
        _x.referencedObjectName = referencedObjectName;
        return _x;
    }

    @Property(name="referencedProperty")
    @JsonIgnore
    public Optional<String> getReferencedProperty() {
        return Optional.ofNullable(referencedProperty);
    }

    public ReferencedObject withReferencedProperty(String referencedProperty) {
        ReferencedObject _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.referencedObject");
        _x.referencedProperty = referencedProperty;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String referencedObjectName;
        private String referencedProperty;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder referencedObjectName(String referencedObjectName) {
            this.referencedObjectName = referencedObjectName;
            this.changedFields = changedFields.add("referencedObjectName");
            return this;
        }

        public Builder referencedProperty(String referencedProperty) {
            this.referencedProperty = referencedProperty;
            this.changedFields = changedFields.add("referencedProperty");
            return this;
        }

        public ReferencedObject build() {
            ReferencedObject _x = new ReferencedObject();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.referencedObject";
            _x.referencedObjectName = referencedObjectName;
            _x.referencedProperty = referencedProperty;
            return _x;
        }
    }

    private ReferencedObject _copy() {
        ReferencedObject _x = new ReferencedObject();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.referencedObjectName = referencedObjectName;
        _x.referencedProperty = referencedProperty;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ReferencedObject[");
        b.append("referencedObjectName=");
        b.append(this.referencedObjectName);
        b.append(", ");
        b.append("referencedProperty=");
        b.append(this.referencedProperty);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
