package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RecurrenceRangeType;

@JsonPropertyOrder({
    "@odata.type", 
    "type", 
    "startDate", 
    "endDate", 
    "recurrenceTimeZone", 
    "numberOfOccurrences"})
@JsonInclude(Include.NON_NULL)
public class RecurrenceRange implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("type")
    protected RecurrenceRangeType type;

    @JsonProperty("startDate")
    protected LocalDate startDate;

    @JsonProperty("endDate")
    protected LocalDate endDate;

    @JsonProperty("recurrenceTimeZone")
    protected String recurrenceTimeZone;

    @JsonProperty("numberOfOccurrences")
    protected Integer numberOfOccurrences;

    protected RecurrenceRange() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.recurrenceRange";
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<RecurrenceRangeType> getType() {
        return Optional.ofNullable(type);
    }

    public RecurrenceRange withType(RecurrenceRangeType type) {
        RecurrenceRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recurrenceRange");
        _x.type = type;
        return _x;
    }

    @Property(name="startDate")
    @JsonIgnore
    public Optional<LocalDate> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    public RecurrenceRange withStartDate(LocalDate startDate) {
        RecurrenceRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recurrenceRange");
        _x.startDate = startDate;
        return _x;
    }

    @Property(name="endDate")
    @JsonIgnore
    public Optional<LocalDate> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    public RecurrenceRange withEndDate(LocalDate endDate) {
        RecurrenceRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recurrenceRange");
        _x.endDate = endDate;
        return _x;
    }

    @Property(name="recurrenceTimeZone")
    @JsonIgnore
    public Optional<String> getRecurrenceTimeZone() {
        return Optional.ofNullable(recurrenceTimeZone);
    }

    public RecurrenceRange withRecurrenceTimeZone(String recurrenceTimeZone) {
        RecurrenceRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recurrenceRange");
        _x.recurrenceTimeZone = recurrenceTimeZone;
        return _x;
    }

    @Property(name="numberOfOccurrences")
    @JsonIgnore
    public Optional<Integer> getNumberOfOccurrences() {
        return Optional.ofNullable(numberOfOccurrences);
    }

    public RecurrenceRange withNumberOfOccurrences(Integer numberOfOccurrences) {
        RecurrenceRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recurrenceRange");
        _x.numberOfOccurrences = numberOfOccurrences;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private RecurrenceRangeType type;
        private LocalDate startDate;
        private LocalDate endDate;
        private String recurrenceTimeZone;
        private Integer numberOfOccurrences;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder type(RecurrenceRangeType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            this.startDate = startDate;
            this.changedFields = changedFields.add("startDate");
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            this.endDate = endDate;
            this.changedFields = changedFields.add("endDate");
            return this;
        }

        public Builder recurrenceTimeZone(String recurrenceTimeZone) {
            this.recurrenceTimeZone = recurrenceTimeZone;
            this.changedFields = changedFields.add("recurrenceTimeZone");
            return this;
        }

        public Builder numberOfOccurrences(Integer numberOfOccurrences) {
            this.numberOfOccurrences = numberOfOccurrences;
            this.changedFields = changedFields.add("numberOfOccurrences");
            return this;
        }

        public RecurrenceRange build() {
            RecurrenceRange _x = new RecurrenceRange();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.recurrenceRange";
            _x.type = type;
            _x.startDate = startDate;
            _x.endDate = endDate;
            _x.recurrenceTimeZone = recurrenceTimeZone;
            _x.numberOfOccurrences = numberOfOccurrences;
            return _x;
        }
    }

    private RecurrenceRange _copy() {
        RecurrenceRange _x = new RecurrenceRange();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.type = type;
        _x.startDate = startDate;
        _x.endDate = endDate;
        _x.recurrenceTimeZone = recurrenceTimeZone;
        _x.numberOfOccurrences = numberOfOccurrences;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RecurrenceRange[");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("startDate=");
        b.append(this.startDate);
        b.append(", ");
        b.append("endDate=");
        b.append(this.endDate);
        b.append(", ");
        b.append("recurrenceTimeZone=");
        b.append(this.recurrenceTimeZone);
        b.append(", ");
        b.append("numberOfOccurrences=");
        b.append(this.numberOfOccurrences);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
