package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DayOfWeek;
import odata.msgraph.client.beta.enums.RecurrencePatternType;
import odata.msgraph.client.beta.enums.WeekIndex;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "type", 
    "interval", 
    "month", 
    "dayOfMonth", 
    "daysOfWeek", 
    "firstDayOfWeek", 
    "index"})
@JsonInclude(Include.NON_NULL)
public class RecurrencePattern implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("type")
    protected RecurrencePatternType type;

    @JsonProperty("interval")
    protected Integer interval;

    @JsonProperty("month")
    protected Integer month;

    @JsonProperty("dayOfMonth")
    protected Integer dayOfMonth;

    @JsonProperty("daysOfWeek")
    protected List<DayOfWeek> daysOfWeek;

    @JsonProperty("daysOfWeek@nextLink")
    protected String daysOfWeekNextLink;

    @JsonProperty("firstDayOfWeek")
    protected DayOfWeek firstDayOfWeek;

    @JsonProperty("index")
    protected WeekIndex index;

    protected RecurrencePattern() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.recurrencePattern";
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<RecurrencePatternType> getType() {
        return Optional.ofNullable(type);
    }

    public RecurrencePattern withType(RecurrencePatternType type) {
        RecurrencePattern _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recurrencePattern");
        _x.type = type;
        return _x;
    }

    @Property(name="interval")
    @JsonIgnore
    public Optional<Integer> getInterval() {
        return Optional.ofNullable(interval);
    }

    public RecurrencePattern withInterval(Integer interval) {
        RecurrencePattern _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recurrencePattern");
        _x.interval = interval;
        return _x;
    }

    @Property(name="month")
    @JsonIgnore
    public Optional<Integer> getMonth() {
        return Optional.ofNullable(month);
    }

    public RecurrencePattern withMonth(Integer month) {
        RecurrencePattern _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recurrencePattern");
        _x.month = month;
        return _x;
    }

    @Property(name="dayOfMonth")
    @JsonIgnore
    public Optional<Integer> getDayOfMonth() {
        return Optional.ofNullable(dayOfMonth);
    }

    public RecurrencePattern withDayOfMonth(Integer dayOfMonth) {
        RecurrencePattern _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recurrencePattern");
        _x.dayOfMonth = dayOfMonth;
        return _x;
    }

    @Property(name="daysOfWeek")
    @JsonIgnore
    public CollectionPage<DayOfWeek> getDaysOfWeek() {
        return new CollectionPage<DayOfWeek>(contextPath, DayOfWeek.class, daysOfWeek, Optional.ofNullable(daysOfWeekNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="daysOfWeek")
    @JsonIgnore
    public CollectionPage<DayOfWeek> getDaysOfWeek(HttpRequestOptions options) {
        return new CollectionPage<DayOfWeek>(contextPath, DayOfWeek.class, daysOfWeek, Optional.ofNullable(daysOfWeekNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="firstDayOfWeek")
    @JsonIgnore
    public Optional<DayOfWeek> getFirstDayOfWeek() {
        return Optional.ofNullable(firstDayOfWeek);
    }

    public RecurrencePattern withFirstDayOfWeek(DayOfWeek firstDayOfWeek) {
        RecurrencePattern _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recurrencePattern");
        _x.firstDayOfWeek = firstDayOfWeek;
        return _x;
    }

    @Property(name="index")
    @JsonIgnore
    public Optional<WeekIndex> getIndex() {
        return Optional.ofNullable(index);
    }

    public RecurrencePattern withIndex(WeekIndex index) {
        RecurrencePattern _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recurrencePattern");
        _x.index = index;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private RecurrencePatternType type;
        private Integer interval;
        private Integer month;
        private Integer dayOfMonth;
        private List<DayOfWeek> daysOfWeek;
        private String daysOfWeekNextLink;
        private DayOfWeek firstDayOfWeek;
        private WeekIndex index;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder type(RecurrencePatternType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder interval(Integer interval) {
            this.interval = interval;
            this.changedFields = changedFields.add("interval");
            return this;
        }

        public Builder month(Integer month) {
            this.month = month;
            this.changedFields = changedFields.add("month");
            return this;
        }

        public Builder dayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            this.changedFields = changedFields.add("dayOfMonth");
            return this;
        }

        public Builder daysOfWeek(List<DayOfWeek> daysOfWeek) {
            this.daysOfWeek = daysOfWeek;
            this.changedFields = changedFields.add("daysOfWeek");
            return this;
        }

        public Builder daysOfWeek(DayOfWeek... daysOfWeek) {
            return daysOfWeek(Arrays.asList(daysOfWeek));
        }

        public Builder daysOfWeekNextLink(String daysOfWeekNextLink) {
            this.daysOfWeekNextLink = daysOfWeekNextLink;
            this.changedFields = changedFields.add("daysOfWeek");
            return this;
        }

        public Builder firstDayOfWeek(DayOfWeek firstDayOfWeek) {
            this.firstDayOfWeek = firstDayOfWeek;
            this.changedFields = changedFields.add("firstDayOfWeek");
            return this;
        }

        public Builder index(WeekIndex index) {
            this.index = index;
            this.changedFields = changedFields.add("index");
            return this;
        }

        public RecurrencePattern build() {
            RecurrencePattern _x = new RecurrencePattern();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.recurrencePattern";
            _x.type = type;
            _x.interval = interval;
            _x.month = month;
            _x.dayOfMonth = dayOfMonth;
            _x.daysOfWeek = daysOfWeek;
            _x.daysOfWeekNextLink = daysOfWeekNextLink;
            _x.firstDayOfWeek = firstDayOfWeek;
            _x.index = index;
            return _x;
        }
    }

    private RecurrencePattern _copy() {
        RecurrencePattern _x = new RecurrencePattern();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.type = type;
        _x.interval = interval;
        _x.month = month;
        _x.dayOfMonth = dayOfMonth;
        _x.daysOfWeek = daysOfWeek;
        _x.firstDayOfWeek = firstDayOfWeek;
        _x.index = index;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RecurrencePattern[");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("interval=");
        b.append(this.interval);
        b.append(", ");
        b.append("month=");
        b.append(this.month);
        b.append(", ");
        b.append("dayOfMonth=");
        b.append(this.dayOfMonth);
        b.append(", ");
        b.append("daysOfWeek=");
        b.append(this.daysOfWeek);
        b.append(", ");
        b.append("firstDayOfWeek=");
        b.append(this.firstDayOfWeek);
        b.append(", ");
        b.append("index=");
        b.append(this.index);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
