package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "level", 
    "versionId"})
@JsonInclude(Include.NON_NULL)
public class PublicationFacet implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("level")
    protected String level;

    @JsonProperty("versionId")
    protected String versionId;

    protected PublicationFacet() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.publicationFacet";
    }

    @Property(name="level")
    @JsonIgnore
    public Optional<String> getLevel() {
        return Optional.ofNullable(level);
    }

    public PublicationFacet withLevel(String level) {
        PublicationFacet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.publicationFacet");
        _x.level = level;
        return _x;
    }

    @Property(name="versionId")
    @JsonIgnore
    public Optional<String> getVersionId() {
        return Optional.ofNullable(versionId);
    }

    public PublicationFacet withVersionId(String versionId) {
        PublicationFacet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.publicationFacet");
        _x.versionId = versionId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String level;
        private String versionId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder level(String level) {
            this.level = level;
            this.changedFields = changedFields.add("level");
            return this;
        }

        public Builder versionId(String versionId) {
            this.versionId = versionId;
            this.changedFields = changedFields.add("versionId");
            return this;
        }

        public PublicationFacet build() {
            PublicationFacet _x = new PublicationFacet();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.publicationFacet";
            _x.level = level;
            _x.versionId = versionId;
            return _x;
        }
    }

    private PublicationFacet _copy() {
        PublicationFacet _x = new PublicationFacet();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.level = level;
        _x.versionId = versionId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PublicationFacet[");
        b.append("level=");
        b.append(this.level);
        b.append(", ");
        b.append("versionId=");
        b.append(this.versionId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
