package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "code", 
    "details", 
    "message", 
    "target"})
@JsonInclude(Include.NON_NULL)
public class PublicInnerError implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("code")
    protected String code;

    @JsonProperty("details")
    protected List<PublicErrorDetail> details;

    @JsonProperty("details@nextLink")
    protected String detailsNextLink;

    @JsonProperty("message")
    protected String message;

    @JsonProperty("target")
    protected String target;

    protected PublicInnerError() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.publicInnerError";
    }

    @Property(name="code")
    @JsonIgnore
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    public PublicInnerError withCode(String code) {
        PublicInnerError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.publicInnerError");
        _x.code = code;
        return _x;
    }

    @Property(name="details")
    @JsonIgnore
    public CollectionPage<PublicErrorDetail> getDetails() {
        return new CollectionPage<PublicErrorDetail>(contextPath, PublicErrorDetail.class, details, Optional.ofNullable(detailsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="details")
    @JsonIgnore
    public CollectionPage<PublicErrorDetail> getDetails(HttpRequestOptions options) {
        return new CollectionPage<PublicErrorDetail>(contextPath, PublicErrorDetail.class, details, Optional.ofNullable(detailsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public PublicInnerError withMessage(String message) {
        PublicInnerError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.publicInnerError");
        _x.message = message;
        return _x;
    }

    @Property(name="target")
    @JsonIgnore
    public Optional<String> getTarget() {
        return Optional.ofNullable(target);
    }

    public PublicInnerError withTarget(String target) {
        PublicInnerError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.publicInnerError");
        _x.target = target;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String code;
        private List<PublicErrorDetail> details;
        private String detailsNextLink;
        private String message;
        private String target;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder code(String code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        public Builder details(List<PublicErrorDetail> details) {
            this.details = details;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public Builder details(PublicErrorDetail... details) {
            return details(Arrays.asList(details));
        }

        public Builder detailsNextLink(String detailsNextLink) {
            this.detailsNextLink = detailsNextLink;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public PublicInnerError build() {
            PublicInnerError _x = new PublicInnerError();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.publicInnerError";
            _x.code = code;
            _x.details = details;
            _x.detailsNextLink = detailsNextLink;
            _x.message = message;
            _x.target = target;
            return _x;
        }
    }

    private PublicInnerError _copy() {
        PublicInnerError _x = new PublicInnerError();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.code = code;
        _x.details = details;
        _x.message = message;
        _x.target = target;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PublicInnerError[");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("details=");
        b.append(this.details);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
