package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "redirectUris"})
@JsonInclude(Include.NON_NULL)
public class PublicClientApplication implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("redirectUris")
    protected List<String> redirectUris;

    @JsonProperty("redirectUris@nextLink")
    protected String redirectUrisNextLink;

    protected PublicClientApplication() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.publicClientApplication";
    }

    @Property(name="redirectUris")
    @JsonIgnore
    public CollectionPage<String> getRedirectUris() {
        return new CollectionPage<String>(contextPath, String.class, redirectUris, Optional.ofNullable(redirectUrisNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="redirectUris")
    @JsonIgnore
    public CollectionPage<String> getRedirectUris(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, redirectUris, Optional.ofNullable(redirectUrisNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> redirectUris;
        private String redirectUrisNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder redirectUris(List<String> redirectUris) {
            this.redirectUris = redirectUris;
            this.changedFields = changedFields.add("redirectUris");
            return this;
        }

        public Builder redirectUris(String... redirectUris) {
            return redirectUris(Arrays.asList(redirectUris));
        }

        public Builder redirectUrisNextLink(String redirectUrisNextLink) {
            this.redirectUrisNextLink = redirectUrisNextLink;
            this.changedFields = changedFields.add("redirectUris");
            return this;
        }

        public PublicClientApplication build() {
            PublicClientApplication _x = new PublicClientApplication();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.publicClientApplication";
            _x.redirectUris = redirectUris;
            _x.redirectUrisNextLink = redirectUrisNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PublicClientApplication[");
        b.append("redirectUris=");
        b.append(this.redirectUris);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
