package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "displayName", 
    "details"})
@JsonInclude(Include.NON_NULL)
public class ProvisioningSystemDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("details")
    protected DetailsInfo details;

    protected ProvisioningSystemDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.provisioningSystemDetails";
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public ProvisioningSystemDetails withId(String id) {
        ProvisioningSystemDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningSystemDetails");
        _x.id = id;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ProvisioningSystemDetails withDisplayName(String displayName) {
        ProvisioningSystemDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningSystemDetails");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="details")
    @JsonIgnore
    public Optional<DetailsInfo> getDetails() {
        return Optional.ofNullable(details);
    }

    public ProvisioningSystemDetails withDetails(DetailsInfo details) {
        ProvisioningSystemDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningSystemDetails");
        _x.details = details;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private DetailsInfo details;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder details(DetailsInfo details) {
            this.details = details;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public ProvisioningSystemDetails build() {
            ProvisioningSystemDetails _x = new ProvisioningSystemDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.provisioningSystemDetails";
            _x.id = id;
            _x.displayName = displayName;
            _x.details = details;
            return _x;
        }
    }

    private ProvisioningSystemDetails _copy() {
        ProvisioningSystemDetails _x = new ProvisioningSystemDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.details = details;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProvisioningSystemDetails[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("details=");
        b.append(this.details);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
