package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.ProvisioningResult;
import odata.msgraph.client.beta.enums.ProvisioningStepType;

@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "status", 
    "description", 
    "details", 
    "provisioningStepType"})
@JsonInclude(Include.NON_NULL)
public class ProvisioningStep implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("status")
    protected ProvisioningResult status;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("details")
    protected DetailsInfo details;

    @JsonProperty("provisioningStepType")
    protected ProvisioningStepType provisioningStepType;

    protected ProvisioningStep() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.provisioningStep";
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ProvisioningStep withName(String name) {
        ProvisioningStep _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningStep");
        _x.name = name;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<ProvisioningResult> getStatus() {
        return Optional.ofNullable(status);
    }

    public ProvisioningStep withStatus(ProvisioningResult status) {
        ProvisioningStep _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningStep");
        _x.status = status;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ProvisioningStep withDescription(String description) {
        ProvisioningStep _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningStep");
        _x.description = description;
        return _x;
    }

    @Property(name="details")
    @JsonIgnore
    public Optional<DetailsInfo> getDetails() {
        return Optional.ofNullable(details);
    }

    public ProvisioningStep withDetails(DetailsInfo details) {
        ProvisioningStep _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningStep");
        _x.details = details;
        return _x;
    }

    @Property(name="provisioningStepType")
    @JsonIgnore
    public Optional<ProvisioningStepType> getProvisioningStepType() {
        return Optional.ofNullable(provisioningStepType);
    }

    public ProvisioningStep withProvisioningStepType(ProvisioningStepType provisioningStepType) {
        ProvisioningStep _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningStep");
        _x.provisioningStepType = provisioningStepType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private ProvisioningResult status;
        private String description;
        private DetailsInfo details;
        private ProvisioningStepType provisioningStepType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder status(ProvisioningResult status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder details(DetailsInfo details) {
            this.details = details;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public Builder provisioningStepType(ProvisioningStepType provisioningStepType) {
            this.provisioningStepType = provisioningStepType;
            this.changedFields = changedFields.add("provisioningStepType");
            return this;
        }

        public ProvisioningStep build() {
            ProvisioningStep _x = new ProvisioningStep();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.provisioningStep";
            _x.name = name;
            _x.status = status;
            _x.description = description;
            _x.details = details;
            _x.provisioningStepType = provisioningStepType;
            return _x;
        }
    }

    private ProvisioningStep _copy() {
        ProvisioningStep _x = new ProvisioningStep();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.status = status;
        _x.description = description;
        _x.details = details;
        _x.provisioningStepType = provisioningStepType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProvisioningStep[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("details=");
        b.append(this.details);
        b.append(", ");
        b.append("provisioningStepType=");
        b.append(this.provisioningStepType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
