package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.SiteAccessType;

@JsonPropertyOrder({
    "@odata.type", 
    "accessType"})
@JsonInclude(Include.NON_NULL)
public class ProtectSite extends LabelActionBase implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("accessType")
    protected SiteAccessType accessType;

    protected ProtectSite() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.protectSite";
    }

    @Property(name="accessType")
    @JsonIgnore
    public Optional<SiteAccessType> getAccessType() {
        return Optional.ofNullable(accessType);
    }

    public ProtectSite withAccessType(SiteAccessType accessType) {
        ProtectSite _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.protectSite");
        _x.accessType = accessType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderProtectSite() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private SiteAccessType accessType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder accessType(SiteAccessType accessType) {
            this.accessType = accessType;
            this.changedFields = changedFields.add("accessType");
            return this;
        }

        public ProtectSite build() {
            ProtectSite _x = new ProtectSite();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.protectSite";
            _x.name = name;
            _x.accessType = accessType;
            return _x;
        }
    }

    private ProtectSite _copy() {
        ProtectSite _x = new ProtectSite();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.accessType = accessType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProtectSite[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("accessType=");
        b.append(this.accessType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
