package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.GroupPrivacy;

@JsonPropertyOrder({
    "@odata.type", 
    "allowEmailFromGuestUsers", 
    "allowGuestUsers", 
    "privacy"})
@JsonInclude(Include.NON_NULL)
public class ProtectGroup extends LabelActionBase implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("allowEmailFromGuestUsers")
    protected Boolean allowEmailFromGuestUsers;

    @JsonProperty("allowGuestUsers")
    protected Boolean allowGuestUsers;

    @JsonProperty("privacy")
    protected GroupPrivacy privacy;

    protected ProtectGroup() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.protectGroup";
    }

    @Property(name="allowEmailFromGuestUsers")
    @JsonIgnore
    public Optional<Boolean> getAllowEmailFromGuestUsers() {
        return Optional.ofNullable(allowEmailFromGuestUsers);
    }

    public ProtectGroup withAllowEmailFromGuestUsers(Boolean allowEmailFromGuestUsers) {
        ProtectGroup _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.protectGroup");
        _x.allowEmailFromGuestUsers = allowEmailFromGuestUsers;
        return _x;
    }

    @Property(name="allowGuestUsers")
    @JsonIgnore
    public Optional<Boolean> getAllowGuestUsers() {
        return Optional.ofNullable(allowGuestUsers);
    }

    public ProtectGroup withAllowGuestUsers(Boolean allowGuestUsers) {
        ProtectGroup _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.protectGroup");
        _x.allowGuestUsers = allowGuestUsers;
        return _x;
    }

    @Property(name="privacy")
    @JsonIgnore
    public Optional<GroupPrivacy> getPrivacy() {
        return Optional.ofNullable(privacy);
    }

    public ProtectGroup withPrivacy(GroupPrivacy privacy) {
        ProtectGroup _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.protectGroup");
        _x.privacy = privacy;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderProtectGroup() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private Boolean allowEmailFromGuestUsers;
        private Boolean allowGuestUsers;
        private GroupPrivacy privacy;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder allowEmailFromGuestUsers(Boolean allowEmailFromGuestUsers) {
            this.allowEmailFromGuestUsers = allowEmailFromGuestUsers;
            this.changedFields = changedFields.add("allowEmailFromGuestUsers");
            return this;
        }

        public Builder allowGuestUsers(Boolean allowGuestUsers) {
            this.allowGuestUsers = allowGuestUsers;
            this.changedFields = changedFields.add("allowGuestUsers");
            return this;
        }

        public Builder privacy(GroupPrivacy privacy) {
            this.privacy = privacy;
            this.changedFields = changedFields.add("privacy");
            return this;
        }

        public ProtectGroup build() {
            ProtectGroup _x = new ProtectGroup();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.protectGroup";
            _x.name = name;
            _x.allowEmailFromGuestUsers = allowEmailFromGuestUsers;
            _x.allowGuestUsers = allowGuestUsers;
            _x.privacy = privacy;
            return _x;
        }
    }

    private ProtectGroup _copy() {
        ProtectGroup _x = new ProtectGroup();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.allowEmailFromGuestUsers = allowEmailFromGuestUsers;
        _x.allowGuestUsers = allowGuestUsers;
        _x.privacy = privacy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProtectGroup[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("allowEmailFromGuestUsers=");
        b.append(this.allowEmailFromGuestUsers);
        b.append(", ");
        b.append("allowGuestUsers=");
        b.append(this.allowGuestUsers);
        b.append(", ");
        b.append("privacy=");
        b.append(this.privacy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
