package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "propertyName", 
    "propertyValue"})
@JsonInclude(Include.NON_NULL)
public class PropertyToEvaluate implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("propertyName")
    protected String propertyName;

    @JsonProperty("propertyValue")
    protected String propertyValue;

    protected PropertyToEvaluate() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.propertyToEvaluate";
    }

    @Property(name="propertyName")
    @JsonIgnore
    public Optional<String> getPropertyName() {
        return Optional.ofNullable(propertyName);
    }

    public PropertyToEvaluate withPropertyName(String propertyName) {
        PropertyToEvaluate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.propertyToEvaluate");
        _x.propertyName = propertyName;
        return _x;
    }

    @Property(name="propertyValue")
    @JsonIgnore
    public Optional<String> getPropertyValue() {
        return Optional.ofNullable(propertyValue);
    }

    public PropertyToEvaluate withPropertyValue(String propertyValue) {
        PropertyToEvaluate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.propertyToEvaluate");
        _x.propertyValue = propertyValue;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String propertyName;
        private String propertyValue;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            this.changedFields = changedFields.add("propertyName");
            return this;
        }

        public Builder propertyValue(String propertyValue) {
            this.propertyValue = propertyValue;
            this.changedFields = changedFields.add("propertyValue");
            return this;
        }

        public PropertyToEvaluate build() {
            PropertyToEvaluate _x = new PropertyToEvaluate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.propertyToEvaluate";
            _x.propertyName = propertyName;
            _x.propertyValue = propertyValue;
            return _x;
        }
    }

    private PropertyToEvaluate _copy() {
        PropertyToEvaluate _x = new PropertyToEvaluate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.propertyName = propertyName;
        _x.propertyValue = propertyValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PropertyToEvaluate[");
        b.append("propertyName=");
        b.append(this.propertyName);
        b.append(", ");
        b.append("propertyValue=");
        b.append(this.propertyValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
