package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ProcessIntegrityLevel;

@JsonPropertyOrder({
    "@odata.type", 
    "accountName", 
    "commandLine", 
    "createdDateTime", 
    "fileHash", 
    "integrityLevel", 
    "isElevated", 
    "name", 
    "parentProcessCreatedDateTime", 
    "parentProcessId", 
    "parentProcessName", 
    "path", 
    "processId"})
@JsonInclude(Include.NON_NULL)
public class Process implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("accountName")
    protected String accountName;

    @JsonProperty("commandLine")
    protected String commandLine;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("fileHash")
    protected FileHash fileHash;

    @JsonProperty("integrityLevel")
    protected ProcessIntegrityLevel integrityLevel;

    @JsonProperty("isElevated")
    protected Boolean isElevated;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("parentProcessCreatedDateTime")
    protected OffsetDateTime parentProcessCreatedDateTime;

    @JsonProperty("parentProcessId")
    protected Integer parentProcessId;

    @JsonProperty("parentProcessName")
    protected String parentProcessName;

    @JsonProperty("path")
    protected String path;

    @JsonProperty("processId")
    protected Integer processId;

    protected Process() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.process";
    }

    @Property(name="accountName")
    @JsonIgnore
    public Optional<String> getAccountName() {
        return Optional.ofNullable(accountName);
    }

    public Process withAccountName(String accountName) {
        Process _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.process");
        _x.accountName = accountName;
        return _x;
    }

    @Property(name="commandLine")
    @JsonIgnore
    public Optional<String> getCommandLine() {
        return Optional.ofNullable(commandLine);
    }

    public Process withCommandLine(String commandLine) {
        Process _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.process");
        _x.commandLine = commandLine;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Process withCreatedDateTime(OffsetDateTime createdDateTime) {
        Process _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.process");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="fileHash")
    @JsonIgnore
    public Optional<FileHash> getFileHash() {
        return Optional.ofNullable(fileHash);
    }

    public Process withFileHash(FileHash fileHash) {
        Process _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.process");
        _x.fileHash = fileHash;
        return _x;
    }

    @Property(name="integrityLevel")
    @JsonIgnore
    public Optional<ProcessIntegrityLevel> getIntegrityLevel() {
        return Optional.ofNullable(integrityLevel);
    }

    public Process withIntegrityLevel(ProcessIntegrityLevel integrityLevel) {
        Process _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.process");
        _x.integrityLevel = integrityLevel;
        return _x;
    }

    @Property(name="isElevated")
    @JsonIgnore
    public Optional<Boolean> getIsElevated() {
        return Optional.ofNullable(isElevated);
    }

    public Process withIsElevated(Boolean isElevated) {
        Process _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.process");
        _x.isElevated = isElevated;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Process withName(String name) {
        Process _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.process");
        _x.name = name;
        return _x;
    }

    @Property(name="parentProcessCreatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getParentProcessCreatedDateTime() {
        return Optional.ofNullable(parentProcessCreatedDateTime);
    }

    public Process withParentProcessCreatedDateTime(OffsetDateTime parentProcessCreatedDateTime) {
        Process _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.process");
        _x.parentProcessCreatedDateTime = parentProcessCreatedDateTime;
        return _x;
    }

    @Property(name="parentProcessId")
    @JsonIgnore
    public Optional<Integer> getParentProcessId() {
        return Optional.ofNullable(parentProcessId);
    }

    public Process withParentProcessId(Integer parentProcessId) {
        Process _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.process");
        _x.parentProcessId = parentProcessId;
        return _x;
    }

    @Property(name="parentProcessName")
    @JsonIgnore
    public Optional<String> getParentProcessName() {
        return Optional.ofNullable(parentProcessName);
    }

    public Process withParentProcessName(String parentProcessName) {
        Process _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.process");
        _x.parentProcessName = parentProcessName;
        return _x;
    }

    @Property(name="path")
    @JsonIgnore
    public Optional<String> getPath() {
        return Optional.ofNullable(path);
    }

    public Process withPath(String path) {
        Process _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.process");
        _x.path = path;
        return _x;
    }

    @Property(name="processId")
    @JsonIgnore
    public Optional<Integer> getProcessId() {
        return Optional.ofNullable(processId);
    }

    public Process withProcessId(Integer processId) {
        Process _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.process");
        _x.processId = processId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String accountName;
        private String commandLine;
        private OffsetDateTime createdDateTime;
        private FileHash fileHash;
        private ProcessIntegrityLevel integrityLevel;
        private Boolean isElevated;
        private String name;
        private OffsetDateTime parentProcessCreatedDateTime;
        private Integer parentProcessId;
        private String parentProcessName;
        private String path;
        private Integer processId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder accountName(String accountName) {
            this.accountName = accountName;
            this.changedFields = changedFields.add("accountName");
            return this;
        }

        public Builder commandLine(String commandLine) {
            this.commandLine = commandLine;
            this.changedFields = changedFields.add("commandLine");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder fileHash(FileHash fileHash) {
            this.fileHash = fileHash;
            this.changedFields = changedFields.add("fileHash");
            return this;
        }

        public Builder integrityLevel(ProcessIntegrityLevel integrityLevel) {
            this.integrityLevel = integrityLevel;
            this.changedFields = changedFields.add("integrityLevel");
            return this;
        }

        public Builder isElevated(Boolean isElevated) {
            this.isElevated = isElevated;
            this.changedFields = changedFields.add("isElevated");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder parentProcessCreatedDateTime(OffsetDateTime parentProcessCreatedDateTime) {
            this.parentProcessCreatedDateTime = parentProcessCreatedDateTime;
            this.changedFields = changedFields.add("parentProcessCreatedDateTime");
            return this;
        }

        public Builder parentProcessId(Integer parentProcessId) {
            this.parentProcessId = parentProcessId;
            this.changedFields = changedFields.add("parentProcessId");
            return this;
        }

        public Builder parentProcessName(String parentProcessName) {
            this.parentProcessName = parentProcessName;
            this.changedFields = changedFields.add("parentProcessName");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.changedFields = changedFields.add("path");
            return this;
        }

        public Builder processId(Integer processId) {
            this.processId = processId;
            this.changedFields = changedFields.add("processId");
            return this;
        }

        public Process build() {
            Process _x = new Process();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.process";
            _x.accountName = accountName;
            _x.commandLine = commandLine;
            _x.createdDateTime = createdDateTime;
            _x.fileHash = fileHash;
            _x.integrityLevel = integrityLevel;
            _x.isElevated = isElevated;
            _x.name = name;
            _x.parentProcessCreatedDateTime = parentProcessCreatedDateTime;
            _x.parentProcessId = parentProcessId;
            _x.parentProcessName = parentProcessName;
            _x.path = path;
            _x.processId = processId;
            return _x;
        }
    }

    private Process _copy() {
        Process _x = new Process();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.accountName = accountName;
        _x.commandLine = commandLine;
        _x.createdDateTime = createdDateTime;
        _x.fileHash = fileHash;
        _x.integrityLevel = integrityLevel;
        _x.isElevated = isElevated;
        _x.name = name;
        _x.parentProcessCreatedDateTime = parentProcessCreatedDateTime;
        _x.parentProcessId = parentProcessId;
        _x.parentProcessName = parentProcessName;
        _x.path = path;
        _x.processId = processId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Process[");
        b.append("accountName=");
        b.append(this.accountName);
        b.append(", ");
        b.append("commandLine=");
        b.append(this.commandLine);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("fileHash=");
        b.append(this.fileHash);
        b.append(", ");
        b.append("integrityLevel=");
        b.append(this.integrityLevel);
        b.append(", ");
        b.append("isElevated=");
        b.append(this.isElevated);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("parentProcessCreatedDateTime=");
        b.append(this.parentProcessCreatedDateTime);
        b.append(", ");
        b.append("parentProcessId=");
        b.append(this.parentProcessId);
        b.append(", ");
        b.append("parentProcessName=");
        b.append(this.parentProcessName);
        b.append(", ");
        b.append("path=");
        b.append(this.path);
        b.append(", ");
        b.append("processId=");
        b.append(this.processId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
