package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.PrinterProcessingState;
import odata.msgraph.client.beta.enums.PrinterProcessingStateReason;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "processingState", 
    "processingStateReasons", 
    "processingStateDescription"})
@JsonInclude(Include.NON_NULL)
public class PrinterStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("processingState")
    protected PrinterProcessingState processingState;

    @JsonProperty("processingStateReasons")
    protected List<PrinterProcessingStateReason> processingStateReasons;

    @JsonProperty("processingStateReasons@nextLink")
    protected String processingStateReasonsNextLink;

    @JsonProperty("processingStateDescription")
    protected String processingStateDescription;

    protected PrinterStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printerStatus";
    }

    @Property(name="processingState")
    @JsonIgnore
    public Optional<PrinterProcessingState> getProcessingState() {
        return Optional.ofNullable(processingState);
    }

    public PrinterStatus withProcessingState(PrinterProcessingState processingState) {
        PrinterStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerStatus");
        _x.processingState = processingState;
        return _x;
    }

    @Property(name="processingStateReasons")
    @JsonIgnore
    public CollectionPage<PrinterProcessingStateReason> getProcessingStateReasons() {
        return new CollectionPage<PrinterProcessingStateReason>(contextPath, PrinterProcessingStateReason.class, processingStateReasons, Optional.ofNullable(processingStateReasonsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="processingStateReasons")
    @JsonIgnore
    public CollectionPage<PrinterProcessingStateReason> getProcessingStateReasons(HttpRequestOptions options) {
        return new CollectionPage<PrinterProcessingStateReason>(contextPath, PrinterProcessingStateReason.class, processingStateReasons, Optional.ofNullable(processingStateReasonsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="processingStateDescription")
    @JsonIgnore
    public Optional<String> getProcessingStateDescription() {
        return Optional.ofNullable(processingStateDescription);
    }

    public PrinterStatus withProcessingStateDescription(String processingStateDescription) {
        PrinterStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerStatus");
        _x.processingStateDescription = processingStateDescription;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PrinterProcessingState processingState;
        private List<PrinterProcessingStateReason> processingStateReasons;
        private String processingStateReasonsNextLink;
        private String processingStateDescription;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder processingState(PrinterProcessingState processingState) {
            this.processingState = processingState;
            this.changedFields = changedFields.add("processingState");
            return this;
        }

        public Builder processingStateReasons(List<PrinterProcessingStateReason> processingStateReasons) {
            this.processingStateReasons = processingStateReasons;
            this.changedFields = changedFields.add("processingStateReasons");
            return this;
        }

        public Builder processingStateReasons(PrinterProcessingStateReason... processingStateReasons) {
            return processingStateReasons(Arrays.asList(processingStateReasons));
        }

        public Builder processingStateReasonsNextLink(String processingStateReasonsNextLink) {
            this.processingStateReasonsNextLink = processingStateReasonsNextLink;
            this.changedFields = changedFields.add("processingStateReasons");
            return this;
        }

        public Builder processingStateDescription(String processingStateDescription) {
            this.processingStateDescription = processingStateDescription;
            this.changedFields = changedFields.add("processingStateDescription");
            return this;
        }

        public PrinterStatus build() {
            PrinterStatus _x = new PrinterStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.printerStatus";
            _x.processingState = processingState;
            _x.processingStateReasons = processingStateReasons;
            _x.processingStateReasonsNextLink = processingStateReasonsNextLink;
            _x.processingStateDescription = processingStateDescription;
            return _x;
        }
    }

    private PrinterStatus _copy() {
        PrinterStatus _x = new PrinterStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.processingState = processingState;
        _x.processingStateReasons = processingStateReasons;
        _x.processingStateDescription = processingStateDescription;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrinterStatus[");
        b.append("processingState=");
        b.append(this.processingState);
        b.append(", ");
        b.append("processingStateReasons=");
        b.append(this.processingStateReasons);
        b.append(", ");
        b.append("processingStateDescription=");
        b.append(this.processingStateDescription);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
