package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.PrintColorMode;
import odata.msgraph.client.beta.enums.PrintDuplexMode;
import odata.msgraph.client.beta.enums.PrintFinishing;
import odata.msgraph.client.beta.enums.PrintMultipageLayout;
import odata.msgraph.client.beta.enums.PrintOrientation;
import odata.msgraph.client.beta.enums.PrintQuality;
import odata.msgraph.client.beta.enums.PrintScaling;
import odata.msgraph.client.beta.enums.PrinterFeedDirection;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "pageRanges", 
    "quality", 
    "dpi", 
    "feedDirection", 
    "orientation", 
    "duplexMode", 
    "copies", 
    "colorMode", 
    "inputBin", 
    "outputBin", 
    "mediaSize", 
    "margin", 
    "mediaType", 
    "finishings", 
    "pagesPerSheet", 
    "multipageLayout", 
    "collate", 
    "scaling", 
    "fitPdfToPage"})
@JsonInclude(Include.NON_NULL)
public class PrinterDocumentConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("pageRanges")
    protected List<IntegerRange> pageRanges;

    @JsonProperty("pageRanges@nextLink")
    protected String pageRangesNextLink;

    @JsonProperty("quality")
    protected PrintQuality quality;

    @JsonProperty("dpi")
    protected Integer dpi;

    @JsonProperty("feedDirection")
    protected PrinterFeedDirection feedDirection;

    @JsonProperty("orientation")
    protected PrintOrientation orientation;

    @JsonProperty("duplexMode")
    protected PrintDuplexMode duplexMode;

    @JsonProperty("copies")
    protected Integer copies;

    @JsonProperty("colorMode")
    protected PrintColorMode colorMode;

    @JsonProperty("inputBin")
    protected String inputBin;

    @JsonProperty("outputBin")
    protected String outputBin;

    @JsonProperty("mediaSize")
    protected String mediaSize;

    @JsonProperty("margin")
    protected PrintMargin margin;

    @JsonProperty("mediaType")
    protected String mediaType;

    @JsonProperty("finishings")
    protected List<PrintFinishing> finishings;

    @JsonProperty("finishings@nextLink")
    protected String finishingsNextLink;

    @JsonProperty("pagesPerSheet")
    protected Integer pagesPerSheet;

    @JsonProperty("multipageLayout")
    protected PrintMultipageLayout multipageLayout;

    @JsonProperty("collate")
    protected Boolean collate;

    @JsonProperty("scaling")
    protected PrintScaling scaling;

    @JsonProperty("fitPdfToPage")
    protected Boolean fitPdfToPage;

    protected PrinterDocumentConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printerDocumentConfiguration";
    }

    @Property(name="pageRanges")
    @JsonIgnore
    public CollectionPage<IntegerRange> getPageRanges() {
        return new CollectionPage<IntegerRange>(contextPath, IntegerRange.class, pageRanges, Optional.ofNullable(pageRangesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="pageRanges")
    @JsonIgnore
    public CollectionPage<IntegerRange> getPageRanges(HttpRequestOptions options) {
        return new CollectionPage<IntegerRange>(contextPath, IntegerRange.class, pageRanges, Optional.ofNullable(pageRangesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="quality")
    @JsonIgnore
    public Optional<PrintQuality> getQuality() {
        return Optional.ofNullable(quality);
    }

    public PrinterDocumentConfiguration withQuality(PrintQuality quality) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.quality = quality;
        return _x;
    }

    @Property(name="dpi")
    @JsonIgnore
    public Optional<Integer> getDpi() {
        return Optional.ofNullable(dpi);
    }

    public PrinterDocumentConfiguration withDpi(Integer dpi) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.dpi = dpi;
        return _x;
    }

    @Property(name="feedDirection")
    @JsonIgnore
    public Optional<PrinterFeedDirection> getFeedDirection() {
        return Optional.ofNullable(feedDirection);
    }

    public PrinterDocumentConfiguration withFeedDirection(PrinterFeedDirection feedDirection) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.feedDirection = feedDirection;
        return _x;
    }

    @Property(name="orientation")
    @JsonIgnore
    public Optional<PrintOrientation> getOrientation() {
        return Optional.ofNullable(orientation);
    }

    public PrinterDocumentConfiguration withOrientation(PrintOrientation orientation) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.orientation = orientation;
        return _x;
    }

    @Property(name="duplexMode")
    @JsonIgnore
    public Optional<PrintDuplexMode> getDuplexMode() {
        return Optional.ofNullable(duplexMode);
    }

    public PrinterDocumentConfiguration withDuplexMode(PrintDuplexMode duplexMode) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.duplexMode = duplexMode;
        return _x;
    }

    @Property(name="copies")
    @JsonIgnore
    public Optional<Integer> getCopies() {
        return Optional.ofNullable(copies);
    }

    public PrinterDocumentConfiguration withCopies(Integer copies) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.copies = copies;
        return _x;
    }

    @Property(name="colorMode")
    @JsonIgnore
    public Optional<PrintColorMode> getColorMode() {
        return Optional.ofNullable(colorMode);
    }

    public PrinterDocumentConfiguration withColorMode(PrintColorMode colorMode) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.colorMode = colorMode;
        return _x;
    }

    @Property(name="inputBin")
    @JsonIgnore
    public Optional<String> getInputBin() {
        return Optional.ofNullable(inputBin);
    }

    public PrinterDocumentConfiguration withInputBin(String inputBin) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.inputBin = inputBin;
        return _x;
    }

    @Property(name="outputBin")
    @JsonIgnore
    public Optional<String> getOutputBin() {
        return Optional.ofNullable(outputBin);
    }

    public PrinterDocumentConfiguration withOutputBin(String outputBin) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.outputBin = outputBin;
        return _x;
    }

    @Property(name="mediaSize")
    @JsonIgnore
    public Optional<String> getMediaSize() {
        return Optional.ofNullable(mediaSize);
    }

    public PrinterDocumentConfiguration withMediaSize(String mediaSize) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.mediaSize = mediaSize;
        return _x;
    }

    @Property(name="margin")
    @JsonIgnore
    public Optional<PrintMargin> getMargin() {
        return Optional.ofNullable(margin);
    }

    public PrinterDocumentConfiguration withMargin(PrintMargin margin) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.margin = margin;
        return _x;
    }

    @Property(name="mediaType")
    @JsonIgnore
    public Optional<String> getMediaType() {
        return Optional.ofNullable(mediaType);
    }

    public PrinterDocumentConfiguration withMediaType(String mediaType) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.mediaType = mediaType;
        return _x;
    }

    @Property(name="finishings")
    @JsonIgnore
    public CollectionPage<PrintFinishing> getFinishings() {
        return new CollectionPage<PrintFinishing>(contextPath, PrintFinishing.class, finishings, Optional.ofNullable(finishingsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="finishings")
    @JsonIgnore
    public CollectionPage<PrintFinishing> getFinishings(HttpRequestOptions options) {
        return new CollectionPage<PrintFinishing>(contextPath, PrintFinishing.class, finishings, Optional.ofNullable(finishingsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="pagesPerSheet")
    @JsonIgnore
    public Optional<Integer> getPagesPerSheet() {
        return Optional.ofNullable(pagesPerSheet);
    }

    public PrinterDocumentConfiguration withPagesPerSheet(Integer pagesPerSheet) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.pagesPerSheet = pagesPerSheet;
        return _x;
    }

    @Property(name="multipageLayout")
    @JsonIgnore
    public Optional<PrintMultipageLayout> getMultipageLayout() {
        return Optional.ofNullable(multipageLayout);
    }

    public PrinterDocumentConfiguration withMultipageLayout(PrintMultipageLayout multipageLayout) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.multipageLayout = multipageLayout;
        return _x;
    }

    @Property(name="collate")
    @JsonIgnore
    public Optional<Boolean> getCollate() {
        return Optional.ofNullable(collate);
    }

    public PrinterDocumentConfiguration withCollate(Boolean collate) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.collate = collate;
        return _x;
    }

    @Property(name="scaling")
    @JsonIgnore
    public Optional<PrintScaling> getScaling() {
        return Optional.ofNullable(scaling);
    }

    public PrinterDocumentConfiguration withScaling(PrintScaling scaling) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.scaling = scaling;
        return _x;
    }

    @Property(name="fitPdfToPage")
    @JsonIgnore
    public Optional<Boolean> getFitPdfToPage() {
        return Optional.ofNullable(fitPdfToPage);
    }

    public PrinterDocumentConfiguration withFitPdfToPage(Boolean fitPdfToPage) {
        PrinterDocumentConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDocumentConfiguration");
        _x.fitPdfToPage = fitPdfToPage;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<IntegerRange> pageRanges;
        private String pageRangesNextLink;
        private PrintQuality quality;
        private Integer dpi;
        private PrinterFeedDirection feedDirection;
        private PrintOrientation orientation;
        private PrintDuplexMode duplexMode;
        private Integer copies;
        private PrintColorMode colorMode;
        private String inputBin;
        private String outputBin;
        private String mediaSize;
        private PrintMargin margin;
        private String mediaType;
        private List<PrintFinishing> finishings;
        private String finishingsNextLink;
        private Integer pagesPerSheet;
        private PrintMultipageLayout multipageLayout;
        private Boolean collate;
        private PrintScaling scaling;
        private Boolean fitPdfToPage;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder pageRanges(List<IntegerRange> pageRanges) {
            this.pageRanges = pageRanges;
            this.changedFields = changedFields.add("pageRanges");
            return this;
        }

        public Builder pageRanges(IntegerRange... pageRanges) {
            return pageRanges(Arrays.asList(pageRanges));
        }

        public Builder pageRangesNextLink(String pageRangesNextLink) {
            this.pageRangesNextLink = pageRangesNextLink;
            this.changedFields = changedFields.add("pageRanges");
            return this;
        }

        public Builder quality(PrintQuality quality) {
            this.quality = quality;
            this.changedFields = changedFields.add("quality");
            return this;
        }

        public Builder dpi(Integer dpi) {
            this.dpi = dpi;
            this.changedFields = changedFields.add("dpi");
            return this;
        }

        public Builder feedDirection(PrinterFeedDirection feedDirection) {
            this.feedDirection = feedDirection;
            this.changedFields = changedFields.add("feedDirection");
            return this;
        }

        public Builder orientation(PrintOrientation orientation) {
            this.orientation = orientation;
            this.changedFields = changedFields.add("orientation");
            return this;
        }

        public Builder duplexMode(PrintDuplexMode duplexMode) {
            this.duplexMode = duplexMode;
            this.changedFields = changedFields.add("duplexMode");
            return this;
        }

        public Builder copies(Integer copies) {
            this.copies = copies;
            this.changedFields = changedFields.add("copies");
            return this;
        }

        public Builder colorMode(PrintColorMode colorMode) {
            this.colorMode = colorMode;
            this.changedFields = changedFields.add("colorMode");
            return this;
        }

        public Builder inputBin(String inputBin) {
            this.inputBin = inputBin;
            this.changedFields = changedFields.add("inputBin");
            return this;
        }

        public Builder outputBin(String outputBin) {
            this.outputBin = outputBin;
            this.changedFields = changedFields.add("outputBin");
            return this;
        }

        public Builder mediaSize(String mediaSize) {
            this.mediaSize = mediaSize;
            this.changedFields = changedFields.add("mediaSize");
            return this;
        }

        public Builder margin(PrintMargin margin) {
            this.margin = margin;
            this.changedFields = changedFields.add("margin");
            return this;
        }

        public Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            this.changedFields = changedFields.add("mediaType");
            return this;
        }

        public Builder finishings(List<PrintFinishing> finishings) {
            this.finishings = finishings;
            this.changedFields = changedFields.add("finishings");
            return this;
        }

        public Builder finishings(PrintFinishing... finishings) {
            return finishings(Arrays.asList(finishings));
        }

        public Builder finishingsNextLink(String finishingsNextLink) {
            this.finishingsNextLink = finishingsNextLink;
            this.changedFields = changedFields.add("finishings");
            return this;
        }

        public Builder pagesPerSheet(Integer pagesPerSheet) {
            this.pagesPerSheet = pagesPerSheet;
            this.changedFields = changedFields.add("pagesPerSheet");
            return this;
        }

        public Builder multipageLayout(PrintMultipageLayout multipageLayout) {
            this.multipageLayout = multipageLayout;
            this.changedFields = changedFields.add("multipageLayout");
            return this;
        }

        public Builder collate(Boolean collate) {
            this.collate = collate;
            this.changedFields = changedFields.add("collate");
            return this;
        }

        public Builder scaling(PrintScaling scaling) {
            this.scaling = scaling;
            this.changedFields = changedFields.add("scaling");
            return this;
        }

        public Builder fitPdfToPage(Boolean fitPdfToPage) {
            this.fitPdfToPage = fitPdfToPage;
            this.changedFields = changedFields.add("fitPdfToPage");
            return this;
        }

        public PrinterDocumentConfiguration build() {
            PrinterDocumentConfiguration _x = new PrinterDocumentConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.printerDocumentConfiguration";
            _x.pageRanges = pageRanges;
            _x.pageRangesNextLink = pageRangesNextLink;
            _x.quality = quality;
            _x.dpi = dpi;
            _x.feedDirection = feedDirection;
            _x.orientation = orientation;
            _x.duplexMode = duplexMode;
            _x.copies = copies;
            _x.colorMode = colorMode;
            _x.inputBin = inputBin;
            _x.outputBin = outputBin;
            _x.mediaSize = mediaSize;
            _x.margin = margin;
            _x.mediaType = mediaType;
            _x.finishings = finishings;
            _x.finishingsNextLink = finishingsNextLink;
            _x.pagesPerSheet = pagesPerSheet;
            _x.multipageLayout = multipageLayout;
            _x.collate = collate;
            _x.scaling = scaling;
            _x.fitPdfToPage = fitPdfToPage;
            return _x;
        }
    }

    private PrinterDocumentConfiguration _copy() {
        PrinterDocumentConfiguration _x = new PrinterDocumentConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.pageRanges = pageRanges;
        _x.quality = quality;
        _x.dpi = dpi;
        _x.feedDirection = feedDirection;
        _x.orientation = orientation;
        _x.duplexMode = duplexMode;
        _x.copies = copies;
        _x.colorMode = colorMode;
        _x.inputBin = inputBin;
        _x.outputBin = outputBin;
        _x.mediaSize = mediaSize;
        _x.margin = margin;
        _x.mediaType = mediaType;
        _x.finishings = finishings;
        _x.pagesPerSheet = pagesPerSheet;
        _x.multipageLayout = multipageLayout;
        _x.collate = collate;
        _x.scaling = scaling;
        _x.fitPdfToPage = fitPdfToPage;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrinterDocumentConfiguration[");
        b.append("pageRanges=");
        b.append(this.pageRanges);
        b.append(", ");
        b.append("quality=");
        b.append(this.quality);
        b.append(", ");
        b.append("dpi=");
        b.append(this.dpi);
        b.append(", ");
        b.append("feedDirection=");
        b.append(this.feedDirection);
        b.append(", ");
        b.append("orientation=");
        b.append(this.orientation);
        b.append(", ");
        b.append("duplexMode=");
        b.append(this.duplexMode);
        b.append(", ");
        b.append("copies=");
        b.append(this.copies);
        b.append(", ");
        b.append("colorMode=");
        b.append(this.colorMode);
        b.append(", ");
        b.append("inputBin=");
        b.append(this.inputBin);
        b.append(", ");
        b.append("outputBin=");
        b.append(this.outputBin);
        b.append(", ");
        b.append("mediaSize=");
        b.append(this.mediaSize);
        b.append(", ");
        b.append("margin=");
        b.append(this.margin);
        b.append(", ");
        b.append("mediaType=");
        b.append(this.mediaType);
        b.append(", ");
        b.append("finishings=");
        b.append(this.finishings);
        b.append(", ");
        b.append("pagesPerSheet=");
        b.append(this.pagesPerSheet);
        b.append(", ");
        b.append("multipageLayout=");
        b.append(this.multipageLayout);
        b.append(", ");
        b.append("collate=");
        b.append(this.collate);
        b.append(", ");
        b.append("scaling=");
        b.append(this.scaling);
        b.append(", ");
        b.append("fitPdfToPage=");
        b.append(this.fitPdfToPage);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
