package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "completedJobCount", 
    "incompleteJobCount"})
@JsonInclude(Include.NON_NULL)
public class PrintUsageSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("completedJobCount")
    protected Integer completedJobCount;

    @JsonProperty("incompleteJobCount")
    protected Integer incompleteJobCount;

    protected PrintUsageSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printUsageSummary";
    }

    @Property(name="completedJobCount")
    @JsonIgnore
    public Optional<Integer> getCompletedJobCount() {
        return Optional.ofNullable(completedJobCount);
    }

    public PrintUsageSummary withCompletedJobCount(Integer completedJobCount) {
        PrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printUsageSummary");
        _x.completedJobCount = completedJobCount;
        return _x;
    }

    @Property(name="incompleteJobCount")
    @JsonIgnore
    public Optional<Integer> getIncompleteJobCount() {
        return Optional.ofNullable(incompleteJobCount);
    }

    public PrintUsageSummary withIncompleteJobCount(Integer incompleteJobCount) {
        PrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printUsageSummary");
        _x.incompleteJobCount = incompleteJobCount;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer completedJobCount;
        private Integer incompleteJobCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder completedJobCount(Integer completedJobCount) {
            this.completedJobCount = completedJobCount;
            this.changedFields = changedFields.add("completedJobCount");
            return this;
        }

        public Builder incompleteJobCount(Integer incompleteJobCount) {
            this.incompleteJobCount = incompleteJobCount;
            this.changedFields = changedFields.add("incompleteJobCount");
            return this;
        }

        public PrintUsageSummary build() {
            PrintUsageSummary _x = new PrintUsageSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.printUsageSummary";
            _x.completedJobCount = completedJobCount;
            _x.incompleteJobCount = incompleteJobCount;
            return _x;
        }
    }

    private PrintUsageSummary _copy() {
        PrintUsageSummary _x = new PrintUsageSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.completedJobCount = completedJobCount;
        _x.incompleteJobCount = incompleteJobCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintUsageSummary[");
        b.append("completedJobCount=");
        b.append(this.completedJobCount);
        b.append(", ");
        b.append("incompleteJobCount=");
        b.append(this.incompleteJobCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
