package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.PrintOperationProcessingState;

@JsonPropertyOrder({
    "@odata.type", 
    "state", 
    "description"})
@JsonInclude(Include.NON_NULL)
public class PrintOperationStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("state")
    protected PrintOperationProcessingState state;

    @JsonProperty("description")
    protected String description;

    protected PrintOperationStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printOperationStatus";
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<PrintOperationProcessingState> getState() {
        return Optional.ofNullable(state);
    }

    public PrintOperationStatus withState(PrintOperationProcessingState state) {
        PrintOperationStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printOperationStatus");
        _x.state = state;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public PrintOperationStatus withDescription(String description) {
        PrintOperationStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printOperationStatus");
        _x.description = description;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PrintOperationProcessingState state;
        private String description;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder state(PrintOperationProcessingState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public PrintOperationStatus build() {
            PrintOperationStatus _x = new PrintOperationStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.printOperationStatus";
            _x.state = state;
            _x.description = description;
            return _x;
        }
    }

    private PrintOperationStatus _copy() {
        PrintOperationStatus _x = new PrintOperationStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.state = state;
        _x.description = description;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintOperationStatus[");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
