package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "top", 
    "bottom", 
    "right", 
    "left"})
@JsonInclude(Include.NON_NULL)
public class PrintMargin implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("top")
    protected Integer top;

    @JsonProperty("bottom")
    protected Integer bottom;

    @JsonProperty("right")
    protected Integer right;

    @JsonProperty("left")
    protected Integer left;

    protected PrintMargin() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printMargin";
    }

    @Property(name="top")
    @JsonIgnore
    public Optional<Integer> getTop() {
        return Optional.ofNullable(top);
    }

    public PrintMargin withTop(Integer top) {
        PrintMargin _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printMargin");
        _x.top = top;
        return _x;
    }

    @Property(name="bottom")
    @JsonIgnore
    public Optional<Integer> getBottom() {
        return Optional.ofNullable(bottom);
    }

    public PrintMargin withBottom(Integer bottom) {
        PrintMargin _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printMargin");
        _x.bottom = bottom;
        return _x;
    }

    @Property(name="right")
    @JsonIgnore
    public Optional<Integer> getRight() {
        return Optional.ofNullable(right);
    }

    public PrintMargin withRight(Integer right) {
        PrintMargin _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printMargin");
        _x.right = right;
        return _x;
    }

    @Property(name="left")
    @JsonIgnore
    public Optional<Integer> getLeft() {
        return Optional.ofNullable(left);
    }

    public PrintMargin withLeft(Integer left) {
        PrintMargin _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printMargin");
        _x.left = left;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer top;
        private Integer bottom;
        private Integer right;
        private Integer left;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder top(Integer top) {
            this.top = top;
            this.changedFields = changedFields.add("top");
            return this;
        }

        public Builder bottom(Integer bottom) {
            this.bottom = bottom;
            this.changedFields = changedFields.add("bottom");
            return this;
        }

        public Builder right(Integer right) {
            this.right = right;
            this.changedFields = changedFields.add("right");
            return this;
        }

        public Builder left(Integer left) {
            this.left = left;
            this.changedFields = changedFields.add("left");
            return this;
        }

        public PrintMargin build() {
            PrintMargin _x = new PrintMargin();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.printMargin";
            _x.top = top;
            _x.bottom = bottom;
            _x.right = right;
            _x.left = left;
            return _x;
        }
    }

    private PrintMargin _copy() {
        PrintMargin _x = new PrintMargin();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.top = top;
        _x.bottom = bottom;
        _x.right = right;
        _x.left = left;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintMargin[");
        b.append("top=");
        b.append(this.top);
        b.append(", ");
        b.append("bottom=");
        b.append(this.bottom);
        b.append(", ");
        b.append("right=");
        b.append(this.right);
        b.append(", ");
        b.append("left=");
        b.append(this.left);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
