package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.PrintJobProcessingState;

@JsonPropertyOrder({
    "@odata.type", 
    "processingState", 
    "processingStateDescription", 
    "acquiredByPrinter"})
@JsonInclude(Include.NON_NULL)
public class PrintJobStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("processingState")
    protected PrintJobProcessingState processingState;

    @JsonProperty("processingStateDescription")
    protected String processingStateDescription;

    @JsonProperty("acquiredByPrinter")
    protected Boolean acquiredByPrinter;

    protected PrintJobStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printJobStatus";
    }

    @Property(name="processingState")
    @JsonIgnore
    public Optional<PrintJobProcessingState> getProcessingState() {
        return Optional.ofNullable(processingState);
    }

    public PrintJobStatus withProcessingState(PrintJobProcessingState processingState) {
        PrintJobStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobStatus");
        _x.processingState = processingState;
        return _x;
    }

    @Property(name="processingStateDescription")
    @JsonIgnore
    public Optional<String> getProcessingStateDescription() {
        return Optional.ofNullable(processingStateDescription);
    }

    public PrintJobStatus withProcessingStateDescription(String processingStateDescription) {
        PrintJobStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobStatus");
        _x.processingStateDescription = processingStateDescription;
        return _x;
    }

    @Property(name="acquiredByPrinter")
    @JsonIgnore
    public Optional<Boolean> getAcquiredByPrinter() {
        return Optional.ofNullable(acquiredByPrinter);
    }

    public PrintJobStatus withAcquiredByPrinter(Boolean acquiredByPrinter) {
        PrintJobStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printJobStatus");
        _x.acquiredByPrinter = acquiredByPrinter;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PrintJobProcessingState processingState;
        private String processingStateDescription;
        private Boolean acquiredByPrinter;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder processingState(PrintJobProcessingState processingState) {
            this.processingState = processingState;
            this.changedFields = changedFields.add("processingState");
            return this;
        }

        public Builder processingStateDescription(String processingStateDescription) {
            this.processingStateDescription = processingStateDescription;
            this.changedFields = changedFields.add("processingStateDescription");
            return this;
        }

        public Builder acquiredByPrinter(Boolean acquiredByPrinter) {
            this.acquiredByPrinter = acquiredByPrinter;
            this.changedFields = changedFields.add("acquiredByPrinter");
            return this;
        }

        public PrintJobStatus build() {
            PrintJobStatus _x = new PrintJobStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.printJobStatus";
            _x.processingState = processingState;
            _x.processingStateDescription = processingStateDescription;
            _x.acquiredByPrinter = acquiredByPrinter;
            return _x;
        }
    }

    private PrintJobStatus _copy() {
        PrintJobStatus _x = new PrintJobStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.processingState = processingState;
        _x.processingStateDescription = processingStateDescription;
        _x.acquiredByPrinter = acquiredByPrinter;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintJobStatus[");
        b.append("processingState=");
        b.append(this.processingState);
        b.append(", ");
        b.append("processingStateDescription=");
        b.append(this.processingStateDescription);
        b.append(", ");
        b.append("acquiredByPrinter=");
        b.append(this.acquiredByPrinter);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
