package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "associationType", 
    "createdDateTime", 
    "displayNameSegments", 
    "ownerAppId"})
@JsonInclude(Include.NON_NULL)
public class PlannerPlanContext implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("associationType")
    protected String associationType;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("displayNameSegments")
    protected List<String> displayNameSegments;

    @JsonProperty("displayNameSegments@nextLink")
    protected String displayNameSegmentsNextLink;

    @JsonProperty("ownerAppId")
    protected String ownerAppId;

    protected PlannerPlanContext() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerPlanContext";
    }

    @Property(name="associationType")
    @JsonIgnore
    public Optional<String> getAssociationType() {
        return Optional.ofNullable(associationType);
    }

    public PlannerPlanContext withAssociationType(String associationType) {
        PlannerPlanContext _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlanContext");
        _x.associationType = associationType;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public PlannerPlanContext withCreatedDateTime(OffsetDateTime createdDateTime) {
        PlannerPlanContext _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlanContext");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="displayNameSegments")
    @JsonIgnore
    public CollectionPage<String> getDisplayNameSegments() {
        return new CollectionPage<String>(contextPath, String.class, displayNameSegments, Optional.ofNullable(displayNameSegmentsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="displayNameSegments")
    @JsonIgnore
    public CollectionPage<String> getDisplayNameSegments(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, displayNameSegments, Optional.ofNullable(displayNameSegmentsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="ownerAppId")
    @JsonIgnore
    public Optional<String> getOwnerAppId() {
        return Optional.ofNullable(ownerAppId);
    }

    public PlannerPlanContext withOwnerAppId(String ownerAppId) {
        PlannerPlanContext _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlanContext");
        _x.ownerAppId = ownerAppId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String associationType;
        private OffsetDateTime createdDateTime;
        private List<String> displayNameSegments;
        private String displayNameSegmentsNextLink;
        private String ownerAppId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder associationType(String associationType) {
            this.associationType = associationType;
            this.changedFields = changedFields.add("associationType");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayNameSegments(List<String> displayNameSegments) {
            this.displayNameSegments = displayNameSegments;
            this.changedFields = changedFields.add("displayNameSegments");
            return this;
        }

        public Builder displayNameSegments(String... displayNameSegments) {
            return displayNameSegments(Arrays.asList(displayNameSegments));
        }

        public Builder displayNameSegmentsNextLink(String displayNameSegmentsNextLink) {
            this.displayNameSegmentsNextLink = displayNameSegmentsNextLink;
            this.changedFields = changedFields.add("displayNameSegments");
            return this;
        }

        public Builder ownerAppId(String ownerAppId) {
            this.ownerAppId = ownerAppId;
            this.changedFields = changedFields.add("ownerAppId");
            return this;
        }

        public PlannerPlanContext build() {
            PlannerPlanContext _x = new PlannerPlanContext();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.plannerPlanContext";
            _x.associationType = associationType;
            _x.createdDateTime = createdDateTime;
            _x.displayNameSegments = displayNameSegments;
            _x.displayNameSegmentsNextLink = displayNameSegmentsNextLink;
            _x.ownerAppId = ownerAppId;
            return _x;
        }
    }

    private PlannerPlanContext _copy() {
        PlannerPlanContext _x = new PlannerPlanContext();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.associationType = associationType;
        _x.createdDateTime = createdDateTime;
        _x.displayNameSegments = displayNameSegments;
        _x.ownerAppId = ownerAppId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerPlanContext[");
        b.append("associationType=");
        b.append(this.associationType);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayNameSegments=");
        b.append(this.displayNameSegments);
        b.append(", ");
        b.append("ownerAppId=");
        b.append(this.ownerAppId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
