package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "orderHint", 
    "planTitle"})
@JsonInclude(Include.NON_NULL)
public class PlannerFavoritePlanReference implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("orderHint")
    protected String orderHint;

    @JsonProperty("planTitle")
    protected String planTitle;

    protected PlannerFavoritePlanReference() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerFavoritePlanReference";
    }

    @Property(name="orderHint")
    @JsonIgnore
    public Optional<String> getOrderHint() {
        return Optional.ofNullable(orderHint);
    }

    public PlannerFavoritePlanReference withOrderHint(String orderHint) {
        PlannerFavoritePlanReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerFavoritePlanReference");
        _x.orderHint = orderHint;
        return _x;
    }

    @Property(name="planTitle")
    @JsonIgnore
    public Optional<String> getPlanTitle() {
        return Optional.ofNullable(planTitle);
    }

    public PlannerFavoritePlanReference withPlanTitle(String planTitle) {
        PlannerFavoritePlanReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerFavoritePlanReference");
        _x.planTitle = planTitle;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String orderHint;
        private String planTitle;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder orderHint(String orderHint) {
            this.orderHint = orderHint;
            this.changedFields = changedFields.add("orderHint");
            return this;
        }

        public Builder planTitle(String planTitle) {
            this.planTitle = planTitle;
            this.changedFields = changedFields.add("planTitle");
            return this;
        }

        public PlannerFavoritePlanReference build() {
            PlannerFavoritePlanReference _x = new PlannerFavoritePlanReference();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.plannerFavoritePlanReference";
            _x.orderHint = orderHint;
            _x.planTitle = planTitle;
            return _x;
        }
    }

    private PlannerFavoritePlanReference _copy() {
        PlannerFavoritePlanReference _x = new PlannerFavoritePlanReference();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.orderHint = orderHint;
        _x.planTitle = planTitle;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerFavoritePlanReference[");
        b.append("orderHint=");
        b.append(this.orderHint);
        b.append(", ");
        b.append("planTitle=");
        b.append(this.planTitle);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
