package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isChecked", 
    "title", 
    "orderHint", 
    "lastModifiedBy", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class PlannerChecklistItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isChecked")
    protected Boolean isChecked;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("orderHint")
    protected String orderHint;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected PlannerChecklistItem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerChecklistItem";
    }

    @Property(name="isChecked")
    @JsonIgnore
    public Optional<Boolean> getIsChecked() {
        return Optional.ofNullable(isChecked);
    }

    public PlannerChecklistItem withIsChecked(Boolean isChecked) {
        PlannerChecklistItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerChecklistItem");
        _x.isChecked = isChecked;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public PlannerChecklistItem withTitle(String title) {
        PlannerChecklistItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerChecklistItem");
        _x.title = title;
        return _x;
    }

    @Property(name="orderHint")
    @JsonIgnore
    public Optional<String> getOrderHint() {
        return Optional.ofNullable(orderHint);
    }

    public PlannerChecklistItem withOrderHint(String orderHint) {
        PlannerChecklistItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerChecklistItem");
        _x.orderHint = orderHint;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public PlannerChecklistItem withLastModifiedBy(IdentitySet lastModifiedBy) {
        PlannerChecklistItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerChecklistItem");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public PlannerChecklistItem withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        PlannerChecklistItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerChecklistItem");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isChecked;
        private String title;
        private String orderHint;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder isChecked(Boolean isChecked) {
            this.isChecked = isChecked;
            this.changedFields = changedFields.add("isChecked");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder orderHint(String orderHint) {
            this.orderHint = orderHint;
            this.changedFields = changedFields.add("orderHint");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public PlannerChecklistItem build() {
            PlannerChecklistItem _x = new PlannerChecklistItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.plannerChecklistItem";
            _x.isChecked = isChecked;
            _x.title = title;
            _x.orderHint = orderHint;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    private PlannerChecklistItem _copy() {
        PlannerChecklistItem _x = new PlannerChecklistItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.isChecked = isChecked;
        _x.title = title;
        _x.orderHint = orderHint;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerChecklistItem[");
        b.append("isChecked=");
        b.append(this.isChecked);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("orderHint=");
        b.append(this.orderHint);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
