package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "category1", 
    "category2", 
    "category3", 
    "category4", 
    "category5", 
    "category6"})
@JsonInclude(Include.NON_NULL)
public class PlannerCategoryDescriptions implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("category1")
    protected String category1;

    @JsonProperty("category2")
    protected String category2;

    @JsonProperty("category3")
    protected String category3;

    @JsonProperty("category4")
    protected String category4;

    @JsonProperty("category5")
    protected String category5;

    @JsonProperty("category6")
    protected String category6;

    protected PlannerCategoryDescriptions() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerCategoryDescriptions";
    }

    @Property(name="category1")
    @JsonIgnore
    public Optional<String> getCategory1() {
        return Optional.ofNullable(category1);
    }

    public PlannerCategoryDescriptions withCategory1(String category1) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category1 = category1;
        return _x;
    }

    @Property(name="category2")
    @JsonIgnore
    public Optional<String> getCategory2() {
        return Optional.ofNullable(category2);
    }

    public PlannerCategoryDescriptions withCategory2(String category2) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category2 = category2;
        return _x;
    }

    @Property(name="category3")
    @JsonIgnore
    public Optional<String> getCategory3() {
        return Optional.ofNullable(category3);
    }

    public PlannerCategoryDescriptions withCategory3(String category3) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category3 = category3;
        return _x;
    }

    @Property(name="category4")
    @JsonIgnore
    public Optional<String> getCategory4() {
        return Optional.ofNullable(category4);
    }

    public PlannerCategoryDescriptions withCategory4(String category4) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category4 = category4;
        return _x;
    }

    @Property(name="category5")
    @JsonIgnore
    public Optional<String> getCategory5() {
        return Optional.ofNullable(category5);
    }

    public PlannerCategoryDescriptions withCategory5(String category5) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category5 = category5;
        return _x;
    }

    @Property(name="category6")
    @JsonIgnore
    public Optional<String> getCategory6() {
        return Optional.ofNullable(category6);
    }

    public PlannerCategoryDescriptions withCategory6(String category6) {
        PlannerCategoryDescriptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerCategoryDescriptions");
        _x.category6 = category6;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String category1;
        private String category2;
        private String category3;
        private String category4;
        private String category5;
        private String category6;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder category1(String category1) {
            this.category1 = category1;
            this.changedFields = changedFields.add("category1");
            return this;
        }

        public Builder category2(String category2) {
            this.category2 = category2;
            this.changedFields = changedFields.add("category2");
            return this;
        }

        public Builder category3(String category3) {
            this.category3 = category3;
            this.changedFields = changedFields.add("category3");
            return this;
        }

        public Builder category4(String category4) {
            this.category4 = category4;
            this.changedFields = changedFields.add("category4");
            return this;
        }

        public Builder category5(String category5) {
            this.category5 = category5;
            this.changedFields = changedFields.add("category5");
            return this;
        }

        public Builder category6(String category6) {
            this.category6 = category6;
            this.changedFields = changedFields.add("category6");
            return this;
        }

        public PlannerCategoryDescriptions build() {
            PlannerCategoryDescriptions _x = new PlannerCategoryDescriptions();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.plannerCategoryDescriptions";
            _x.category1 = category1;
            _x.category2 = category2;
            _x.category3 = category3;
            _x.category4 = category4;
            _x.category5 = category5;
            _x.category6 = category6;
            return _x;
        }
    }

    private PlannerCategoryDescriptions _copy() {
        PlannerCategoryDescriptions _x = new PlannerCategoryDescriptions();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.category1 = category1;
        _x.category2 = category2;
        _x.category3 = category3;
        _x.category4 = category4;
        _x.category5 = category5;
        _x.category6 = category6;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerCategoryDescriptions[");
        b.append("category1=");
        b.append(this.category1);
        b.append(", ");
        b.append("category2=");
        b.append(this.category2);
        b.append(", ");
        b.append("category3=");
        b.append(this.category3);
        b.append(", ");
        b.append("category4=");
        b.append(this.category4);
        b.append(", ");
        b.append("category5=");
        b.append(this.category5);
        b.append(", ");
        b.append("category6=");
        b.append(this.category6);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
