package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.PhysicalAddressType;

@JsonPropertyOrder({
    "@odata.type", 
    "type", 
    "postOfficeBox", 
    "street", 
    "city", 
    "state", 
    "countryOrRegion", 
    "postalCode"})
@JsonInclude(Include.NON_NULL)
public class PhysicalAddress implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("type")
    protected PhysicalAddressType type;

    @JsonProperty("postOfficeBox")
    protected String postOfficeBox;

    @JsonProperty("street")
    protected String street;

    @JsonProperty("city")
    protected String city;

    @JsonProperty("state")
    protected String state;

    @JsonProperty("countryOrRegion")
    protected String countryOrRegion;

    @JsonProperty("postalCode")
    protected String postalCode;

    protected PhysicalAddress() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.physicalAddress";
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<PhysicalAddressType> getType() {
        return Optional.ofNullable(type);
    }

    public PhysicalAddress withType(PhysicalAddressType type) {
        PhysicalAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.physicalAddress");
        _x.type = type;
        return _x;
    }

    @Property(name="postOfficeBox")
    @JsonIgnore
    public Optional<String> getPostOfficeBox() {
        return Optional.ofNullable(postOfficeBox);
    }

    public PhysicalAddress withPostOfficeBox(String postOfficeBox) {
        PhysicalAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.physicalAddress");
        _x.postOfficeBox = postOfficeBox;
        return _x;
    }

    @Property(name="street")
    @JsonIgnore
    public Optional<String> getStreet() {
        return Optional.ofNullable(street);
    }

    public PhysicalAddress withStreet(String street) {
        PhysicalAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.physicalAddress");
        _x.street = street;
        return _x;
    }

    @Property(name="city")
    @JsonIgnore
    public Optional<String> getCity() {
        return Optional.ofNullable(city);
    }

    public PhysicalAddress withCity(String city) {
        PhysicalAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.physicalAddress");
        _x.city = city;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public PhysicalAddress withState(String state) {
        PhysicalAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.physicalAddress");
        _x.state = state;
        return _x;
    }

    @Property(name="countryOrRegion")
    @JsonIgnore
    public Optional<String> getCountryOrRegion() {
        return Optional.ofNullable(countryOrRegion);
    }

    public PhysicalAddress withCountryOrRegion(String countryOrRegion) {
        PhysicalAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.physicalAddress");
        _x.countryOrRegion = countryOrRegion;
        return _x;
    }

    @Property(name="postalCode")
    @JsonIgnore
    public Optional<String> getPostalCode() {
        return Optional.ofNullable(postalCode);
    }

    public PhysicalAddress withPostalCode(String postalCode) {
        PhysicalAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.physicalAddress");
        _x.postalCode = postalCode;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PhysicalAddressType type;
        private String postOfficeBox;
        private String street;
        private String city;
        private String state;
        private String countryOrRegion;
        private String postalCode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder type(PhysicalAddressType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder postOfficeBox(String postOfficeBox) {
            this.postOfficeBox = postOfficeBox;
            this.changedFields = changedFields.add("postOfficeBox");
            return this;
        }

        public Builder street(String street) {
            this.street = street;
            this.changedFields = changedFields.add("street");
            return this;
        }

        public Builder city(String city) {
            this.city = city;
            this.changedFields = changedFields.add("city");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder countryOrRegion(String countryOrRegion) {
            this.countryOrRegion = countryOrRegion;
            this.changedFields = changedFields.add("countryOrRegion");
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            this.changedFields = changedFields.add("postalCode");
            return this;
        }

        public PhysicalAddress build() {
            PhysicalAddress _x = new PhysicalAddress();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.physicalAddress";
            _x.type = type;
            _x.postOfficeBox = postOfficeBox;
            _x.street = street;
            _x.city = city;
            _x.state = state;
            _x.countryOrRegion = countryOrRegion;
            _x.postalCode = postalCode;
            return _x;
        }
    }

    private PhysicalAddress _copy() {
        PhysicalAddress _x = new PhysicalAddress();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.type = type;
        _x.postOfficeBox = postOfficeBox;
        _x.street = street;
        _x.city = city;
        _x.state = state;
        _x.countryOrRegion = countryOrRegion;
        _x.postalCode = postalCode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PhysicalAddress[");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("postOfficeBox=");
        b.append(this.postOfficeBox);
        b.append(", ");
        b.append("street=");
        b.append(this.street);
        b.append(", ");
        b.append("city=");
        b.append(this.city);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("countryOrRegion=");
        b.append(this.countryOrRegion);
        b.append(", ");
        b.append("postalCode=");
        b.append(this.postalCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
