package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.PhoneType;

@JsonPropertyOrder({
    "@odata.type", 
    "type", 
    "number"})
@JsonInclude(Include.NON_NULL)
public class Phone implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("type")
    protected PhoneType type;

    @JsonProperty("number")
    protected String number;

    protected Phone() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.phone";
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<PhoneType> getType() {
        return Optional.ofNullable(type);
    }

    public Phone withType(PhoneType type) {
        Phone _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.phone");
        _x.type = type;
        return _x;
    }

    @Property(name="number")
    @JsonIgnore
    public Optional<String> getNumber() {
        return Optional.ofNullable(number);
    }

    public Phone withNumber(String number) {
        Phone _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.phone");
        _x.number = number;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PhoneType type;
        private String number;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder type(PhoneType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            this.changedFields = changedFields.add("number");
            return this;
        }

        public Phone build() {
            Phone _x = new Phone();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.phone";
            _x.type = type;
            _x.number = number;
            return _x;
        }
    }

    private Phone _copy() {
        Phone _x = new Phone();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.type = type;
        _x.number = number;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Phone[");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("number=");
        b.append(this.number);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
