package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "allowMultipleSelection", 
    "chooseFromType", 
    "displayAs"})
@JsonInclude(Include.NON_NULL)
public class PersonOrGroupColumn implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowMultipleSelection")
    protected Boolean allowMultipleSelection;

    @JsonProperty("chooseFromType")
    protected String chooseFromType;

    @JsonProperty("displayAs")
    protected String displayAs;

    protected PersonOrGroupColumn() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.personOrGroupColumn";
    }

    @Property(name="allowMultipleSelection")
    @JsonIgnore
    public Optional<Boolean> getAllowMultipleSelection() {
        return Optional.ofNullable(allowMultipleSelection);
    }

    public PersonOrGroupColumn withAllowMultipleSelection(Boolean allowMultipleSelection) {
        PersonOrGroupColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personOrGroupColumn");
        _x.allowMultipleSelection = allowMultipleSelection;
        return _x;
    }

    @Property(name="chooseFromType")
    @JsonIgnore
    public Optional<String> getChooseFromType() {
        return Optional.ofNullable(chooseFromType);
    }

    public PersonOrGroupColumn withChooseFromType(String chooseFromType) {
        PersonOrGroupColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personOrGroupColumn");
        _x.chooseFromType = chooseFromType;
        return _x;
    }

    @Property(name="displayAs")
    @JsonIgnore
    public Optional<String> getDisplayAs() {
        return Optional.ofNullable(displayAs);
    }

    public PersonOrGroupColumn withDisplayAs(String displayAs) {
        PersonOrGroupColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.personOrGroupColumn");
        _x.displayAs = displayAs;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowMultipleSelection;
        private String chooseFromType;
        private String displayAs;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder allowMultipleSelection(Boolean allowMultipleSelection) {
            this.allowMultipleSelection = allowMultipleSelection;
            this.changedFields = changedFields.add("allowMultipleSelection");
            return this;
        }

        public Builder chooseFromType(String chooseFromType) {
            this.chooseFromType = chooseFromType;
            this.changedFields = changedFields.add("chooseFromType");
            return this;
        }

        public Builder displayAs(String displayAs) {
            this.displayAs = displayAs;
            this.changedFields = changedFields.add("displayAs");
            return this;
        }

        public PersonOrGroupColumn build() {
            PersonOrGroupColumn _x = new PersonOrGroupColumn();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.personOrGroupColumn";
            _x.allowMultipleSelection = allowMultipleSelection;
            _x.chooseFromType = chooseFromType;
            _x.displayAs = displayAs;
            return _x;
        }
    }

    private PersonOrGroupColumn _copy() {
        PersonOrGroupColumn _x = new PersonOrGroupColumn();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.allowMultipleSelection = allowMultipleSelection;
        _x.chooseFromType = chooseFromType;
        _x.displayAs = displayAs;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PersonOrGroupColumn[");
        b.append("allowMultipleSelection=");
        b.append(this.allowMultipleSelection);
        b.append(", ");
        b.append("chooseFromType=");
        b.append(this.chooseFromType);
        b.append(", ");
        b.append("displayAs=");
        b.append(this.displayAs);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
