package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "adminConsentDescription", 
    "adminConsentDisplayName", 
    "id", 
    "isEnabled", 
    "origin", 
    "type", 
    "userConsentDescription", 
    "userConsentDisplayName", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class PermissionScope implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("adminConsentDescription")
    protected String adminConsentDescription;

    @JsonProperty("adminConsentDisplayName")
    protected String adminConsentDisplayName;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("origin")
    protected String origin;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("userConsentDescription")
    protected String userConsentDescription;

    @JsonProperty("userConsentDisplayName")
    protected String userConsentDisplayName;

    @JsonProperty("value")
    protected String value;

    protected PermissionScope() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.permissionScope";
    }

    @Property(name="adminConsentDescription")
    @JsonIgnore
    public Optional<String> getAdminConsentDescription() {
        return Optional.ofNullable(adminConsentDescription);
    }

    public PermissionScope withAdminConsentDescription(String adminConsentDescription) {
        PermissionScope _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permissionScope");
        _x.adminConsentDescription = adminConsentDescription;
        return _x;
    }

    @Property(name="adminConsentDisplayName")
    @JsonIgnore
    public Optional<String> getAdminConsentDisplayName() {
        return Optional.ofNullable(adminConsentDisplayName);
    }

    public PermissionScope withAdminConsentDisplayName(String adminConsentDisplayName) {
        PermissionScope _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permissionScope");
        _x.adminConsentDisplayName = adminConsentDisplayName;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public PermissionScope withId(String id) {
        PermissionScope _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permissionScope");
        _x.id = id;
        return _x;
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public PermissionScope withIsEnabled(Boolean isEnabled) {
        PermissionScope _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permissionScope");
        _x.isEnabled = isEnabled;
        return _x;
    }

    @Property(name="origin")
    @JsonIgnore
    public Optional<String> getOrigin() {
        return Optional.ofNullable(origin);
    }

    public PermissionScope withOrigin(String origin) {
        PermissionScope _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permissionScope");
        _x.origin = origin;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public PermissionScope withType(String type) {
        PermissionScope _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permissionScope");
        _x.type = type;
        return _x;
    }

    @Property(name="userConsentDescription")
    @JsonIgnore
    public Optional<String> getUserConsentDescription() {
        return Optional.ofNullable(userConsentDescription);
    }

    public PermissionScope withUserConsentDescription(String userConsentDescription) {
        PermissionScope _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permissionScope");
        _x.userConsentDescription = userConsentDescription;
        return _x;
    }

    @Property(name="userConsentDisplayName")
    @JsonIgnore
    public Optional<String> getUserConsentDisplayName() {
        return Optional.ofNullable(userConsentDisplayName);
    }

    public PermissionScope withUserConsentDisplayName(String userConsentDisplayName) {
        PermissionScope _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permissionScope");
        _x.userConsentDisplayName = userConsentDisplayName;
        return _x;
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    public PermissionScope withValue(String value) {
        PermissionScope _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.permissionScope");
        _x.value = value;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String adminConsentDescription;
        private String adminConsentDisplayName;
        private String id;
        private Boolean isEnabled;
        private String origin;
        private String type;
        private String userConsentDescription;
        private String userConsentDisplayName;
        private String value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder adminConsentDescription(String adminConsentDescription) {
            this.adminConsentDescription = adminConsentDescription;
            this.changedFields = changedFields.add("adminConsentDescription");
            return this;
        }

        public Builder adminConsentDisplayName(String adminConsentDisplayName) {
            this.adminConsentDisplayName = adminConsentDisplayName;
            this.changedFields = changedFields.add("adminConsentDisplayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder origin(String origin) {
            this.origin = origin;
            this.changedFields = changedFields.add("origin");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder userConsentDescription(String userConsentDescription) {
            this.userConsentDescription = userConsentDescription;
            this.changedFields = changedFields.add("userConsentDescription");
            return this;
        }

        public Builder userConsentDisplayName(String userConsentDisplayName) {
            this.userConsentDisplayName = userConsentDisplayName;
            this.changedFields = changedFields.add("userConsentDisplayName");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public PermissionScope build() {
            PermissionScope _x = new PermissionScope();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.permissionScope";
            _x.adminConsentDescription = adminConsentDescription;
            _x.adminConsentDisplayName = adminConsentDisplayName;
            _x.id = id;
            _x.isEnabled = isEnabled;
            _x.origin = origin;
            _x.type = type;
            _x.userConsentDescription = userConsentDescription;
            _x.userConsentDisplayName = userConsentDisplayName;
            _x.value = value;
            return _x;
        }
    }

    private PermissionScope _copy() {
        PermissionScope _x = new PermissionScope();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.adminConsentDescription = adminConsentDescription;
        _x.adminConsentDisplayName = adminConsentDisplayName;
        _x.id = id;
        _x.isEnabled = isEnabled;
        _x.origin = origin;
        _x.type = type;
        _x.userConsentDescription = userConsentDescription;
        _x.userConsentDisplayName = userConsentDisplayName;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PermissionScope[");
        b.append("adminConsentDescription=");
        b.append(this.adminConsentDescription);
        b.append(", ");
        b.append("adminConsentDisplayName=");
        b.append(this.adminConsentDisplayName);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("origin=");
        b.append(this.origin);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("userConsentDescription=");
        b.append(this.userConsentDescription);
        b.append(", ");
        b.append("userConsentDisplayName=");
        b.append(this.userConsentDisplayName);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
