package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "pattern", 
    "range"})
@JsonInclude(Include.NON_NULL)
public class PatternedRecurrence implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("pattern")
    protected RecurrencePattern pattern;

    @JsonProperty("range")
    protected RecurrenceRange range;

    protected PatternedRecurrence() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.patternedRecurrence";
    }

    @Property(name="pattern")
    @JsonIgnore
    public Optional<RecurrencePattern> getPattern() {
        return Optional.ofNullable(pattern);
    }

    public PatternedRecurrence withPattern(RecurrencePattern pattern) {
        PatternedRecurrence _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.patternedRecurrence");
        _x.pattern = pattern;
        return _x;
    }

    @Property(name="range")
    @JsonIgnore
    public Optional<RecurrenceRange> getRange() {
        return Optional.ofNullable(range);
    }

    public PatternedRecurrence withRange(RecurrenceRange range) {
        PatternedRecurrence _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.patternedRecurrence");
        _x.range = range;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private RecurrencePattern pattern;
        private RecurrenceRange range;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder pattern(RecurrencePattern pattern) {
            this.pattern = pattern;
            this.changedFields = changedFields.add("pattern");
            return this;
        }

        public Builder range(RecurrenceRange range) {
            this.range = range;
            this.changedFields = changedFields.add("range");
            return this;
        }

        public PatternedRecurrence build() {
            PatternedRecurrence _x = new PatternedRecurrence();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.patternedRecurrence";
            _x.pattern = pattern;
            _x.range = range;
            return _x;
        }
    }

    private PatternedRecurrence _copy() {
        PatternedRecurrence _x = new PatternedRecurrence();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.pattern = pattern;
        _x.range = range;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PatternedRecurrence[");
        b.append("pattern=");
        b.append(this.pattern);
        b.append(", ");
        b.append("range=");
        b.append(this.range);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
