package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "password", 
    "forceChangePasswordNextSignIn", 
    "forceChangePasswordNextSignInWithMfa"})
@JsonInclude(Include.NON_NULL)
public class PasswordProfile implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("password")
    protected String password;

    @JsonProperty("forceChangePasswordNextSignIn")
    protected Boolean forceChangePasswordNextSignIn;

    @JsonProperty("forceChangePasswordNextSignInWithMfa")
    protected Boolean forceChangePasswordNextSignInWithMfa;

    protected PasswordProfile() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.passwordProfile";
    }

    @Property(name="password")
    @JsonIgnore
    public Optional<String> getPassword() {
        return Optional.ofNullable(password);
    }

    public PasswordProfile withPassword(String password) {
        PasswordProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordProfile");
        _x.password = password;
        return _x;
    }

    @Property(name="forceChangePasswordNextSignIn")
    @JsonIgnore
    public Optional<Boolean> getForceChangePasswordNextSignIn() {
        return Optional.ofNullable(forceChangePasswordNextSignIn);
    }

    public PasswordProfile withForceChangePasswordNextSignIn(Boolean forceChangePasswordNextSignIn) {
        PasswordProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordProfile");
        _x.forceChangePasswordNextSignIn = forceChangePasswordNextSignIn;
        return _x;
    }

    @Property(name="forceChangePasswordNextSignInWithMfa")
    @JsonIgnore
    public Optional<Boolean> getForceChangePasswordNextSignInWithMfa() {
        return Optional.ofNullable(forceChangePasswordNextSignInWithMfa);
    }

    public PasswordProfile withForceChangePasswordNextSignInWithMfa(Boolean forceChangePasswordNextSignInWithMfa) {
        PasswordProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordProfile");
        _x.forceChangePasswordNextSignInWithMfa = forceChangePasswordNextSignInWithMfa;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String password;
        private Boolean forceChangePasswordNextSignIn;
        private Boolean forceChangePasswordNextSignInWithMfa;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder password(String password) {
            this.password = password;
            this.changedFields = changedFields.add("password");
            return this;
        }

        public Builder forceChangePasswordNextSignIn(Boolean forceChangePasswordNextSignIn) {
            this.forceChangePasswordNextSignIn = forceChangePasswordNextSignIn;
            this.changedFields = changedFields.add("forceChangePasswordNextSignIn");
            return this;
        }

        public Builder forceChangePasswordNextSignInWithMfa(Boolean forceChangePasswordNextSignInWithMfa) {
            this.forceChangePasswordNextSignInWithMfa = forceChangePasswordNextSignInWithMfa;
            this.changedFields = changedFields.add("forceChangePasswordNextSignInWithMfa");
            return this;
        }

        public PasswordProfile build() {
            PasswordProfile _x = new PasswordProfile();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.passwordProfile";
            _x.password = password;
            _x.forceChangePasswordNextSignIn = forceChangePasswordNextSignIn;
            _x.forceChangePasswordNextSignInWithMfa = forceChangePasswordNextSignInWithMfa;
            return _x;
        }
    }

    private PasswordProfile _copy() {
        PasswordProfile _x = new PasswordProfile();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.password = password;
        _x.forceChangePasswordNextSignIn = forceChangePasswordNextSignIn;
        _x.forceChangePasswordNextSignInWithMfa = forceChangePasswordNextSignInWithMfa;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PasswordProfile[");
        b.append("password=");
        b.append(this.password);
        b.append(", ");
        b.append("forceChangePasswordNextSignIn=");
        b.append(this.forceChangePasswordNextSignIn);
        b.append(", ");
        b.append("forceChangePasswordNextSignInWithMfa=");
        b.append(this.forceChangePasswordNextSignInWithMfa);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
