package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "customKeyIdentifier", 
    "endDateTime", 
    "keyId", 
    "startDateTime", 
    "secretText", 
    "hint", 
    "displayName"})
@JsonInclude(Include.NON_NULL)
public class PasswordCredential implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("customKeyIdentifier")
    protected byte[] customKeyIdentifier;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("keyId")
    protected String keyId;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("secretText")
    protected String secretText;

    @JsonProperty("hint")
    protected String hint;

    @JsonProperty("displayName")
    protected String displayName;

    protected PasswordCredential() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.passwordCredential";
    }

    @Property(name="customKeyIdentifier")
    @JsonIgnore
    public Optional<byte[]> getCustomKeyIdentifier() {
        return Optional.ofNullable(customKeyIdentifier);
    }

    public PasswordCredential withCustomKeyIdentifier(byte[] customKeyIdentifier) {
        PasswordCredential _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordCredential");
        _x.customKeyIdentifier = customKeyIdentifier;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public PasswordCredential withEndDateTime(OffsetDateTime endDateTime) {
        PasswordCredential _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordCredential");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="keyId")
    @JsonIgnore
    public Optional<String> getKeyId() {
        return Optional.ofNullable(keyId);
    }

    public PasswordCredential withKeyId(String keyId) {
        PasswordCredential _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordCredential");
        _x.keyId = keyId;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public PasswordCredential withStartDateTime(OffsetDateTime startDateTime) {
        PasswordCredential _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordCredential");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="secretText")
    @JsonIgnore
    public Optional<String> getSecretText() {
        return Optional.ofNullable(secretText);
    }

    public PasswordCredential withSecretText(String secretText) {
        PasswordCredential _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordCredential");
        _x.secretText = secretText;
        return _x;
    }

    @Property(name="hint")
    @JsonIgnore
    public Optional<String> getHint() {
        return Optional.ofNullable(hint);
    }

    public PasswordCredential withHint(String hint) {
        PasswordCredential _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordCredential");
        _x.hint = hint;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public PasswordCredential withDisplayName(String displayName) {
        PasswordCredential _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordCredential");
        _x.displayName = displayName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private byte[] customKeyIdentifier;
        private OffsetDateTime endDateTime;
        private String keyId;
        private OffsetDateTime startDateTime;
        private String secretText;
        private String hint;
        private String displayName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder customKeyIdentifier(byte[] customKeyIdentifier) {
            this.customKeyIdentifier = customKeyIdentifier;
            this.changedFields = changedFields.add("customKeyIdentifier");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.changedFields = changedFields.add("keyId");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder secretText(String secretText) {
            this.secretText = secretText;
            this.changedFields = changedFields.add("secretText");
            return this;
        }

        public Builder hint(String hint) {
            this.hint = hint;
            this.changedFields = changedFields.add("hint");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public PasswordCredential build() {
            PasswordCredential _x = new PasswordCredential();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.passwordCredential";
            _x.customKeyIdentifier = customKeyIdentifier;
            _x.endDateTime = endDateTime;
            _x.keyId = keyId;
            _x.startDateTime = startDateTime;
            _x.secretText = secretText;
            _x.hint = hint;
            _x.displayName = displayName;
            return _x;
        }
    }

    private PasswordCredential _copy() {
        PasswordCredential _x = new PasswordCredential();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.customKeyIdentifier = customKeyIdentifier;
        _x.endDateTime = endDateTime;
        _x.keyId = keyId;
        _x.startDateTime = startDateTime;
        _x.secretText = secretText;
        _x.hint = hint;
        _x.displayName = displayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PasswordCredential[");
        b.append("customKeyIdentifier=");
        b.append(this.customKeyIdentifier);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("keyId=");
        b.append(this.keyId);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("secretText=");
        b.append(this.secretText);
        b.append(", ");
        b.append("hint=");
        b.append(this.hint);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
