package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.EndpointType;

@JsonPropertyOrder({
    "@odata.type", 
    "identity", 
    "endpointType", 
    "region", 
    "languageId", 
    "countryCode"})
@JsonInclude(Include.NON_NULL)
public class ParticipantInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("identity")
    protected IdentitySet identity;

    @JsonProperty("endpointType")
    protected EndpointType endpointType;

    @JsonProperty("region")
    protected String region;

    @JsonProperty("languageId")
    protected String languageId;

    @JsonProperty("countryCode")
    protected String countryCode;

    protected ParticipantInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.participantInfo";
    }

    @Property(name="identity")
    @JsonIgnore
    public Optional<IdentitySet> getIdentity() {
        return Optional.ofNullable(identity);
    }

    public ParticipantInfo withIdentity(IdentitySet identity) {
        ParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.participantInfo");
        _x.identity = identity;
        return _x;
    }

    @Property(name="endpointType")
    @JsonIgnore
    public Optional<EndpointType> getEndpointType() {
        return Optional.ofNullable(endpointType);
    }

    public ParticipantInfo withEndpointType(EndpointType endpointType) {
        ParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.participantInfo");
        _x.endpointType = endpointType;
        return _x;
    }

    @Property(name="region")
    @JsonIgnore
    public Optional<String> getRegion() {
        return Optional.ofNullable(region);
    }

    public ParticipantInfo withRegion(String region) {
        ParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.participantInfo");
        _x.region = region;
        return _x;
    }

    @Property(name="languageId")
    @JsonIgnore
    public Optional<String> getLanguageId() {
        return Optional.ofNullable(languageId);
    }

    public ParticipantInfo withLanguageId(String languageId) {
        ParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.participantInfo");
        _x.languageId = languageId;
        return _x;
    }

    @Property(name="countryCode")
    @JsonIgnore
    public Optional<String> getCountryCode() {
        return Optional.ofNullable(countryCode);
    }

    public ParticipantInfo withCountryCode(String countryCode) {
        ParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.participantInfo");
        _x.countryCode = countryCode;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IdentitySet identity;
        private EndpointType endpointType;
        private String region;
        private String languageId;
        private String countryCode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder identity(IdentitySet identity) {
            this.identity = identity;
            this.changedFields = changedFields.add("identity");
            return this;
        }

        public Builder endpointType(EndpointType endpointType) {
            this.endpointType = endpointType;
            this.changedFields = changedFields.add("endpointType");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.changedFields = changedFields.add("region");
            return this;
        }

        public Builder languageId(String languageId) {
            this.languageId = languageId;
            this.changedFields = changedFields.add("languageId");
            return this;
        }

        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            this.changedFields = changedFields.add("countryCode");
            return this;
        }

        public ParticipantInfo build() {
            ParticipantInfo _x = new ParticipantInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.participantInfo";
            _x.identity = identity;
            _x.endpointType = endpointType;
            _x.region = region;
            _x.languageId = languageId;
            _x.countryCode = countryCode;
            return _x;
        }
    }

    private ParticipantInfo _copy() {
        ParticipantInfo _x = new ParticipantInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.identity = identity;
        _x.endpointType = endpointType;
        _x.region = region;
        _x.languageId = languageId;
        _x.countryCode = countryCode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ParticipantInfo[");
        b.append("identity=");
        b.append(this.identity);
        b.append(", ");
        b.append("endpointType=");
        b.append(this.endpointType);
        b.append(", ");
        b.append("region=");
        b.append(this.region);
        b.append(", ");
        b.append("languageId=");
        b.append(this.languageId);
        b.append(", ");
        b.append("countryCode=");
        b.append(this.countryCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
