package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "error", 
    "evaluationSucceeded", 
    "evaluationResult", 
    "parsedExpression", 
    "parsingSucceeded"})
@JsonInclude(Include.NON_NULL)
public class ParseExpressionResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("error")
    protected PublicError error;

    @JsonProperty("evaluationSucceeded")
    protected Boolean evaluationSucceeded;

    @JsonProperty("evaluationResult")
    protected List<String> evaluationResult;

    @JsonProperty("evaluationResult@nextLink")
    protected String evaluationResultNextLink;

    @JsonProperty("parsedExpression")
    protected AttributeMappingSource parsedExpression;

    @JsonProperty("parsingSucceeded")
    protected Boolean parsingSucceeded;

    protected ParseExpressionResponse() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.parseExpressionResponse";
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<PublicError> getError() {
        return Optional.ofNullable(error);
    }

    public ParseExpressionResponse withError(PublicError error) {
        ParseExpressionResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.parseExpressionResponse");
        _x.error = error;
        return _x;
    }

    @Property(name="evaluationSucceeded")
    @JsonIgnore
    public Optional<Boolean> getEvaluationSucceeded() {
        return Optional.ofNullable(evaluationSucceeded);
    }

    public ParseExpressionResponse withEvaluationSucceeded(Boolean evaluationSucceeded) {
        ParseExpressionResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.parseExpressionResponse");
        _x.evaluationSucceeded = evaluationSucceeded;
        return _x;
    }

    @Property(name="evaluationResult")
    @JsonIgnore
    public CollectionPage<String> getEvaluationResult() {
        return new CollectionPage<String>(contextPath, String.class, evaluationResult, Optional.ofNullable(evaluationResultNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="evaluationResult")
    @JsonIgnore
    public CollectionPage<String> getEvaluationResult(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, evaluationResult, Optional.ofNullable(evaluationResultNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="parsedExpression")
    @JsonIgnore
    public Optional<AttributeMappingSource> getParsedExpression() {
        return Optional.ofNullable(parsedExpression);
    }

    public ParseExpressionResponse withParsedExpression(AttributeMappingSource parsedExpression) {
        ParseExpressionResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.parseExpressionResponse");
        _x.parsedExpression = parsedExpression;
        return _x;
    }

    @Property(name="parsingSucceeded")
    @JsonIgnore
    public Optional<Boolean> getParsingSucceeded() {
        return Optional.ofNullable(parsingSucceeded);
    }

    public ParseExpressionResponse withParsingSucceeded(Boolean parsingSucceeded) {
        ParseExpressionResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.parseExpressionResponse");
        _x.parsingSucceeded = parsingSucceeded;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PublicError error;
        private Boolean evaluationSucceeded;
        private List<String> evaluationResult;
        private String evaluationResultNextLink;
        private AttributeMappingSource parsedExpression;
        private Boolean parsingSucceeded;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder error(PublicError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder evaluationSucceeded(Boolean evaluationSucceeded) {
            this.evaluationSucceeded = evaluationSucceeded;
            this.changedFields = changedFields.add("evaluationSucceeded");
            return this;
        }

        public Builder evaluationResult(List<String> evaluationResult) {
            this.evaluationResult = evaluationResult;
            this.changedFields = changedFields.add("evaluationResult");
            return this;
        }

        public Builder evaluationResult(String... evaluationResult) {
            return evaluationResult(Arrays.asList(evaluationResult));
        }

        public Builder evaluationResultNextLink(String evaluationResultNextLink) {
            this.evaluationResultNextLink = evaluationResultNextLink;
            this.changedFields = changedFields.add("evaluationResult");
            return this;
        }

        public Builder parsedExpression(AttributeMappingSource parsedExpression) {
            this.parsedExpression = parsedExpression;
            this.changedFields = changedFields.add("parsedExpression");
            return this;
        }

        public Builder parsingSucceeded(Boolean parsingSucceeded) {
            this.parsingSucceeded = parsingSucceeded;
            this.changedFields = changedFields.add("parsingSucceeded");
            return this;
        }

        public ParseExpressionResponse build() {
            ParseExpressionResponse _x = new ParseExpressionResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.parseExpressionResponse";
            _x.error = error;
            _x.evaluationSucceeded = evaluationSucceeded;
            _x.evaluationResult = evaluationResult;
            _x.evaluationResultNextLink = evaluationResultNextLink;
            _x.parsedExpression = parsedExpression;
            _x.parsingSucceeded = parsingSucceeded;
            return _x;
        }
    }

    private ParseExpressionResponse _copy() {
        ParseExpressionResponse _x = new ParseExpressionResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.error = error;
        _x.evaluationSucceeded = evaluationSucceeded;
        _x.evaluationResult = evaluationResult;
        _x.parsedExpression = parsedExpression;
        _x.parsingSucceeded = parsingSucceeded;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ParseExpressionResponse[");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("evaluationSucceeded=");
        b.append(this.evaluationSucceeded);
        b.append(", ");
        b.append("evaluationResult=");
        b.append(this.evaluationResult);
        b.append(", ");
        b.append("parsedExpression=");
        b.append(this.parsedExpression);
        b.append(", ");
        b.append("parsingSucceeded=");
        b.append(this.parsingSucceeded);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
