package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "countriesBlockedForMinors", 
    "legalAgeGroupRule"})
@JsonInclude(Include.NON_NULL)
public class ParentalControlSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("countriesBlockedForMinors")
    protected List<String> countriesBlockedForMinors;

    @JsonProperty("countriesBlockedForMinors@nextLink")
    protected String countriesBlockedForMinorsNextLink;

    @JsonProperty("legalAgeGroupRule")
    protected String legalAgeGroupRule;

    protected ParentalControlSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.parentalControlSettings";
    }

    @Property(name="countriesBlockedForMinors")
    @JsonIgnore
    public CollectionPage<String> getCountriesBlockedForMinors() {
        return new CollectionPage<String>(contextPath, String.class, countriesBlockedForMinors, Optional.ofNullable(countriesBlockedForMinorsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="countriesBlockedForMinors")
    @JsonIgnore
    public CollectionPage<String> getCountriesBlockedForMinors(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, countriesBlockedForMinors, Optional.ofNullable(countriesBlockedForMinorsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="legalAgeGroupRule")
    @JsonIgnore
    public Optional<String> getLegalAgeGroupRule() {
        return Optional.ofNullable(legalAgeGroupRule);
    }

    public ParentalControlSettings withLegalAgeGroupRule(String legalAgeGroupRule) {
        ParentalControlSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.parentalControlSettings");
        _x.legalAgeGroupRule = legalAgeGroupRule;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> countriesBlockedForMinors;
        private String countriesBlockedForMinorsNextLink;
        private String legalAgeGroupRule;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder countriesBlockedForMinors(List<String> countriesBlockedForMinors) {
            this.countriesBlockedForMinors = countriesBlockedForMinors;
            this.changedFields = changedFields.add("countriesBlockedForMinors");
            return this;
        }

        public Builder countriesBlockedForMinors(String... countriesBlockedForMinors) {
            return countriesBlockedForMinors(Arrays.asList(countriesBlockedForMinors));
        }

        public Builder countriesBlockedForMinorsNextLink(String countriesBlockedForMinorsNextLink) {
            this.countriesBlockedForMinorsNextLink = countriesBlockedForMinorsNextLink;
            this.changedFields = changedFields.add("countriesBlockedForMinors");
            return this;
        }

        public Builder legalAgeGroupRule(String legalAgeGroupRule) {
            this.legalAgeGroupRule = legalAgeGroupRule;
            this.changedFields = changedFields.add("legalAgeGroupRule");
            return this;
        }

        public ParentalControlSettings build() {
            ParentalControlSettings _x = new ParentalControlSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.parentalControlSettings";
            _x.countriesBlockedForMinors = countriesBlockedForMinors;
            _x.countriesBlockedForMinorsNextLink = countriesBlockedForMinorsNextLink;
            _x.legalAgeGroupRule = legalAgeGroupRule;
            return _x;
        }
    }

    private ParentalControlSettings _copy() {
        ParentalControlSettings _x = new ParentalControlSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.countriesBlockedForMinors = countriesBlockedForMinors;
        _x.legalAgeGroupRule = legalAgeGroupRule;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ParentalControlSettings[");
        b.append("countriesBlockedForMinors=");
        b.append(this.countriesBlockedForMinors);
        b.append(", ");
        b.append("legalAgeGroupRule=");
        b.append(this.legalAgeGroupRule);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
