package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "topUsers", 
    "topPrinters", 
    "daysInPeriod", 
    "activeUsersCount", 
    "activePrintersCount", 
    "totalJobsProcessed", 
    "totalIncompleteJobs"})
@JsonInclude(Include.NON_NULL)
public class OverallPrintUsageSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("topUsers")
    protected List<UserPrintUsageSummary> topUsers;

    @JsonProperty("topUsers@nextLink")
    protected String topUsersNextLink;

    @JsonProperty("topPrinters")
    protected List<PrinterUsageSummary> topPrinters;

    @JsonProperty("topPrinters@nextLink")
    protected String topPrintersNextLink;

    @JsonProperty("daysInPeriod")
    protected Integer daysInPeriod;

    @JsonProperty("activeUsersCount")
    protected Integer activeUsersCount;

    @JsonProperty("activePrintersCount")
    protected Integer activePrintersCount;

    @JsonProperty("totalJobsProcessed")
    protected Integer totalJobsProcessed;

    @JsonProperty("totalIncompleteJobs")
    protected Integer totalIncompleteJobs;

    protected OverallPrintUsageSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.overallPrintUsageSummary";
    }

    @Property(name="topUsers")
    @JsonIgnore
    public CollectionPage<UserPrintUsageSummary> getTopUsers() {
        return new CollectionPage<UserPrintUsageSummary>(contextPath, UserPrintUsageSummary.class, topUsers, Optional.ofNullable(topUsersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="topUsers")
    @JsonIgnore
    public CollectionPage<UserPrintUsageSummary> getTopUsers(HttpRequestOptions options) {
        return new CollectionPage<UserPrintUsageSummary>(contextPath, UserPrintUsageSummary.class, topUsers, Optional.ofNullable(topUsersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="topPrinters")
    @JsonIgnore
    public CollectionPage<PrinterUsageSummary> getTopPrinters() {
        return new CollectionPage<PrinterUsageSummary>(contextPath, PrinterUsageSummary.class, topPrinters, Optional.ofNullable(topPrintersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="topPrinters")
    @JsonIgnore
    public CollectionPage<PrinterUsageSummary> getTopPrinters(HttpRequestOptions options) {
        return new CollectionPage<PrinterUsageSummary>(contextPath, PrinterUsageSummary.class, topPrinters, Optional.ofNullable(topPrintersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="daysInPeriod")
    @JsonIgnore
    public Optional<Integer> getDaysInPeriod() {
        return Optional.ofNullable(daysInPeriod);
    }

    public OverallPrintUsageSummary withDaysInPeriod(Integer daysInPeriod) {
        OverallPrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.overallPrintUsageSummary");
        _x.daysInPeriod = daysInPeriod;
        return _x;
    }

    @Property(name="activeUsersCount")
    @JsonIgnore
    public Optional<Integer> getActiveUsersCount() {
        return Optional.ofNullable(activeUsersCount);
    }

    public OverallPrintUsageSummary withActiveUsersCount(Integer activeUsersCount) {
        OverallPrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.overallPrintUsageSummary");
        _x.activeUsersCount = activeUsersCount;
        return _x;
    }

    @Property(name="activePrintersCount")
    @JsonIgnore
    public Optional<Integer> getActivePrintersCount() {
        return Optional.ofNullable(activePrintersCount);
    }

    public OverallPrintUsageSummary withActivePrintersCount(Integer activePrintersCount) {
        OverallPrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.overallPrintUsageSummary");
        _x.activePrintersCount = activePrintersCount;
        return _x;
    }

    @Property(name="totalJobsProcessed")
    @JsonIgnore
    public Optional<Integer> getTotalJobsProcessed() {
        return Optional.ofNullable(totalJobsProcessed);
    }

    public OverallPrintUsageSummary withTotalJobsProcessed(Integer totalJobsProcessed) {
        OverallPrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.overallPrintUsageSummary");
        _x.totalJobsProcessed = totalJobsProcessed;
        return _x;
    }

    @Property(name="totalIncompleteJobs")
    @JsonIgnore
    public Optional<Integer> getTotalIncompleteJobs() {
        return Optional.ofNullable(totalIncompleteJobs);
    }

    public OverallPrintUsageSummary withTotalIncompleteJobs(Integer totalIncompleteJobs) {
        OverallPrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.overallPrintUsageSummary");
        _x.totalIncompleteJobs = totalIncompleteJobs;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<UserPrintUsageSummary> topUsers;
        private String topUsersNextLink;
        private List<PrinterUsageSummary> topPrinters;
        private String topPrintersNextLink;
        private Integer daysInPeriod;
        private Integer activeUsersCount;
        private Integer activePrintersCount;
        private Integer totalJobsProcessed;
        private Integer totalIncompleteJobs;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder topUsers(List<UserPrintUsageSummary> topUsers) {
            this.topUsers = topUsers;
            this.changedFields = changedFields.add("topUsers");
            return this;
        }

        public Builder topUsers(UserPrintUsageSummary... topUsers) {
            return topUsers(Arrays.asList(topUsers));
        }

        public Builder topUsersNextLink(String topUsersNextLink) {
            this.topUsersNextLink = topUsersNextLink;
            this.changedFields = changedFields.add("topUsers");
            return this;
        }

        public Builder topPrinters(List<PrinterUsageSummary> topPrinters) {
            this.topPrinters = topPrinters;
            this.changedFields = changedFields.add("topPrinters");
            return this;
        }

        public Builder topPrinters(PrinterUsageSummary... topPrinters) {
            return topPrinters(Arrays.asList(topPrinters));
        }

        public Builder topPrintersNextLink(String topPrintersNextLink) {
            this.topPrintersNextLink = topPrintersNextLink;
            this.changedFields = changedFields.add("topPrinters");
            return this;
        }

        public Builder daysInPeriod(Integer daysInPeriod) {
            this.daysInPeriod = daysInPeriod;
            this.changedFields = changedFields.add("daysInPeriod");
            return this;
        }

        public Builder activeUsersCount(Integer activeUsersCount) {
            this.activeUsersCount = activeUsersCount;
            this.changedFields = changedFields.add("activeUsersCount");
            return this;
        }

        public Builder activePrintersCount(Integer activePrintersCount) {
            this.activePrintersCount = activePrintersCount;
            this.changedFields = changedFields.add("activePrintersCount");
            return this;
        }

        public Builder totalJobsProcessed(Integer totalJobsProcessed) {
            this.totalJobsProcessed = totalJobsProcessed;
            this.changedFields = changedFields.add("totalJobsProcessed");
            return this;
        }

        public Builder totalIncompleteJobs(Integer totalIncompleteJobs) {
            this.totalIncompleteJobs = totalIncompleteJobs;
            this.changedFields = changedFields.add("totalIncompleteJobs");
            return this;
        }

        public OverallPrintUsageSummary build() {
            OverallPrintUsageSummary _x = new OverallPrintUsageSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.overallPrintUsageSummary";
            _x.topUsers = topUsers;
            _x.topUsersNextLink = topUsersNextLink;
            _x.topPrinters = topPrinters;
            _x.topPrintersNextLink = topPrintersNextLink;
            _x.daysInPeriod = daysInPeriod;
            _x.activeUsersCount = activeUsersCount;
            _x.activePrintersCount = activePrintersCount;
            _x.totalJobsProcessed = totalJobsProcessed;
            _x.totalIncompleteJobs = totalIncompleteJobs;
            return _x;
        }
    }

    private OverallPrintUsageSummary _copy() {
        OverallPrintUsageSummary _x = new OverallPrintUsageSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.topUsers = topUsers;
        _x.topPrinters = topPrinters;
        _x.daysInPeriod = daysInPeriod;
        _x.activeUsersCount = activeUsersCount;
        _x.activePrintersCount = activePrintersCount;
        _x.totalJobsProcessed = totalJobsProcessed;
        _x.totalIncompleteJobs = totalIncompleteJobs;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OverallPrintUsageSummary[");
        b.append("topUsers=");
        b.append(this.topUsers);
        b.append(", ");
        b.append("topPrinters=");
        b.append(this.topPrinters);
        b.append(", ");
        b.append("daysInPeriod=");
        b.append(this.daysInPeriod);
        b.append(", ");
        b.append("activeUsersCount=");
        b.append(this.activeUsersCount);
        b.append(", ");
        b.append("activePrintersCount=");
        b.append(this.activePrintersCount);
        b.append(", ");
        b.append("totalJobsProcessed=");
        b.append(this.totalJobsProcessed);
        b.append(", ");
        b.append("totalIncompleteJobs=");
        b.append(this.totalIncompleteJobs);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
