package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "altitude", 
    "latitude", 
    "longitude", 
    "accuracy", 
    "altitudeAccuracy"})
@JsonInclude(Include.NON_NULL)
public class OutlookGeoCoordinates implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("altitude")
    protected Double altitude;

    @JsonProperty("latitude")
    protected Double latitude;

    @JsonProperty("longitude")
    protected Double longitude;

    @JsonProperty("accuracy")
    protected Double accuracy;

    @JsonProperty("altitudeAccuracy")
    protected Double altitudeAccuracy;

    protected OutlookGeoCoordinates() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.outlookGeoCoordinates";
    }

    @Property(name="altitude")
    @JsonIgnore
    public Optional<Double> getAltitude() {
        return Optional.ofNullable(altitude);
    }

    public OutlookGeoCoordinates withAltitude(Double altitude) {
        OutlookGeoCoordinates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookGeoCoordinates");
        _x.altitude = altitude;
        return _x;
    }

    @Property(name="latitude")
    @JsonIgnore
    public Optional<Double> getLatitude() {
        return Optional.ofNullable(latitude);
    }

    public OutlookGeoCoordinates withLatitude(Double latitude) {
        OutlookGeoCoordinates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookGeoCoordinates");
        _x.latitude = latitude;
        return _x;
    }

    @Property(name="longitude")
    @JsonIgnore
    public Optional<Double> getLongitude() {
        return Optional.ofNullable(longitude);
    }

    public OutlookGeoCoordinates withLongitude(Double longitude) {
        OutlookGeoCoordinates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookGeoCoordinates");
        _x.longitude = longitude;
        return _x;
    }

    @Property(name="accuracy")
    @JsonIgnore
    public Optional<Double> getAccuracy() {
        return Optional.ofNullable(accuracy);
    }

    public OutlookGeoCoordinates withAccuracy(Double accuracy) {
        OutlookGeoCoordinates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookGeoCoordinates");
        _x.accuracy = accuracy;
        return _x;
    }

    @Property(name="altitudeAccuracy")
    @JsonIgnore
    public Optional<Double> getAltitudeAccuracy() {
        return Optional.ofNullable(altitudeAccuracy);
    }

    public OutlookGeoCoordinates withAltitudeAccuracy(Double altitudeAccuracy) {
        OutlookGeoCoordinates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.outlookGeoCoordinates");
        _x.altitudeAccuracy = altitudeAccuracy;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Double altitude;
        private Double latitude;
        private Double longitude;
        private Double accuracy;
        private Double altitudeAccuracy;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder altitude(Double altitude) {
            this.altitude = altitude;
            this.changedFields = changedFields.add("altitude");
            return this;
        }

        public Builder latitude(Double latitude) {
            this.latitude = latitude;
            this.changedFields = changedFields.add("latitude");
            return this;
        }

        public Builder longitude(Double longitude) {
            this.longitude = longitude;
            this.changedFields = changedFields.add("longitude");
            return this;
        }

        public Builder accuracy(Double accuracy) {
            this.accuracy = accuracy;
            this.changedFields = changedFields.add("accuracy");
            return this;
        }

        public Builder altitudeAccuracy(Double altitudeAccuracy) {
            this.altitudeAccuracy = altitudeAccuracy;
            this.changedFields = changedFields.add("altitudeAccuracy");
            return this;
        }

        public OutlookGeoCoordinates build() {
            OutlookGeoCoordinates _x = new OutlookGeoCoordinates();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.outlookGeoCoordinates";
            _x.altitude = altitude;
            _x.latitude = latitude;
            _x.longitude = longitude;
            _x.accuracy = accuracy;
            _x.altitudeAccuracy = altitudeAccuracy;
            return _x;
        }
    }

    private OutlookGeoCoordinates _copy() {
        OutlookGeoCoordinates _x = new OutlookGeoCoordinates();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.altitude = altitude;
        _x.latitude = latitude;
        _x.longitude = longitude;
        _x.accuracy = accuracy;
        _x.altitudeAccuracy = altitudeAccuracy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OutlookGeoCoordinates[");
        b.append("altitude=");
        b.append(this.altitude);
        b.append(", ");
        b.append("latitude=");
        b.append(this.latitude);
        b.append(", ");
        b.append("longitude=");
        b.append(this.longitude);
        b.append(", ");
        b.append("accuracy=");
        b.append(this.accuracy);
        b.append(", ");
        b.append("altitudeAccuracy=");
        b.append(this.altitudeAccuracy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
