package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "organizer"})
@JsonInclude(Include.NON_NULL)
public class OrganizerMeetingInfo extends MeetingInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("organizer")
    protected IdentitySet organizer;

    protected OrganizerMeetingInfo() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.organizerMeetingInfo";
    }

    @Property(name="organizer")
    @JsonIgnore
    public Optional<IdentitySet> getOrganizer() {
        return Optional.ofNullable(organizer);
    }

    public OrganizerMeetingInfo withOrganizer(IdentitySet organizer) {
        OrganizerMeetingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.organizerMeetingInfo");
        _x.organizer = organizer;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOrganizerMeetingInfo() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowConversationWithoutHost;
        private IdentitySet organizer;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder allowConversationWithoutHost(Boolean allowConversationWithoutHost) {
            this.allowConversationWithoutHost = allowConversationWithoutHost;
            this.changedFields = changedFields.add("allowConversationWithoutHost");
            return this;
        }

        public Builder organizer(IdentitySet organizer) {
            this.organizer = organizer;
            this.changedFields = changedFields.add("organizer");
            return this;
        }

        public OrganizerMeetingInfo build() {
            OrganizerMeetingInfo _x = new OrganizerMeetingInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.organizerMeetingInfo";
            _x.allowConversationWithoutHost = allowConversationWithoutHost;
            _x.organizer = organizer;
            return _x;
        }
    }

    private OrganizerMeetingInfo _copy() {
        OrganizerMeetingInfo _x = new OrganizerMeetingInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.allowConversationWithoutHost = allowConversationWithoutHost;
        _x.organizer = organizer;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OrganizerMeetingInfo[");
        b.append("allowConversationWithoutHost=");
        b.append(this.allowConversationWithoutHost);
        b.append(", ");
        b.append("organizer=");
        b.append(this.organizer);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
