package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "idToken", 
    "accessToken", 
    "saml2Token"})
@JsonInclude(Include.NON_NULL)
public class OptionalClaims implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("idToken")
    protected List<OptionalClaim> idToken;

    @JsonProperty("idToken@nextLink")
    protected String idTokenNextLink;

    @JsonProperty("accessToken")
    protected List<OptionalClaim> accessToken;

    @JsonProperty("accessToken@nextLink")
    protected String accessTokenNextLink;

    @JsonProperty("saml2Token")
    protected List<OptionalClaim> saml2Token;

    @JsonProperty("saml2Token@nextLink")
    protected String saml2TokenNextLink;

    protected OptionalClaims() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.optionalClaims";
    }

    @Property(name="idToken")
    @JsonIgnore
    public CollectionPage<OptionalClaim> getIdToken() {
        return new CollectionPage<OptionalClaim>(contextPath, OptionalClaim.class, idToken, Optional.ofNullable(idTokenNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="idToken")
    @JsonIgnore
    public CollectionPage<OptionalClaim> getIdToken(HttpRequestOptions options) {
        return new CollectionPage<OptionalClaim>(contextPath, OptionalClaim.class, idToken, Optional.ofNullable(idTokenNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="accessToken")
    @JsonIgnore
    public CollectionPage<OptionalClaim> getAccessToken() {
        return new CollectionPage<OptionalClaim>(contextPath, OptionalClaim.class, accessToken, Optional.ofNullable(accessTokenNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="accessToken")
    @JsonIgnore
    public CollectionPage<OptionalClaim> getAccessToken(HttpRequestOptions options) {
        return new CollectionPage<OptionalClaim>(contextPath, OptionalClaim.class, accessToken, Optional.ofNullable(accessTokenNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="saml2Token")
    @JsonIgnore
    public CollectionPage<OptionalClaim> getSaml2Token() {
        return new CollectionPage<OptionalClaim>(contextPath, OptionalClaim.class, saml2Token, Optional.ofNullable(saml2TokenNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="saml2Token")
    @JsonIgnore
    public CollectionPage<OptionalClaim> getSaml2Token(HttpRequestOptions options) {
        return new CollectionPage<OptionalClaim>(contextPath, OptionalClaim.class, saml2Token, Optional.ofNullable(saml2TokenNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<OptionalClaim> idToken;
        private String idTokenNextLink;
        private List<OptionalClaim> accessToken;
        private String accessTokenNextLink;
        private List<OptionalClaim> saml2Token;
        private String saml2TokenNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder idToken(List<OptionalClaim> idToken) {
            this.idToken = idToken;
            this.changedFields = changedFields.add("idToken");
            return this;
        }

        public Builder idToken(OptionalClaim... idToken) {
            return idToken(Arrays.asList(idToken));
        }

        public Builder idTokenNextLink(String idTokenNextLink) {
            this.idTokenNextLink = idTokenNextLink;
            this.changedFields = changedFields.add("idToken");
            return this;
        }

        public Builder accessToken(List<OptionalClaim> accessToken) {
            this.accessToken = accessToken;
            this.changedFields = changedFields.add("accessToken");
            return this;
        }

        public Builder accessToken(OptionalClaim... accessToken) {
            return accessToken(Arrays.asList(accessToken));
        }

        public Builder accessTokenNextLink(String accessTokenNextLink) {
            this.accessTokenNextLink = accessTokenNextLink;
            this.changedFields = changedFields.add("accessToken");
            return this;
        }

        public Builder saml2Token(List<OptionalClaim> saml2Token) {
            this.saml2Token = saml2Token;
            this.changedFields = changedFields.add("saml2Token");
            return this;
        }

        public Builder saml2Token(OptionalClaim... saml2Token) {
            return saml2Token(Arrays.asList(saml2Token));
        }

        public Builder saml2TokenNextLink(String saml2TokenNextLink) {
            this.saml2TokenNextLink = saml2TokenNextLink;
            this.changedFields = changedFields.add("saml2Token");
            return this;
        }

        public OptionalClaims build() {
            OptionalClaims _x = new OptionalClaims();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.optionalClaims";
            _x.idToken = idToken;
            _x.idTokenNextLink = idTokenNextLink;
            _x.accessToken = accessToken;
            _x.accessTokenNextLink = accessTokenNextLink;
            _x.saml2Token = saml2Token;
            _x.saml2TokenNextLink = saml2TokenNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OptionalClaims[");
        b.append("idToken=");
        b.append(this.idToken);
        b.append(", ");
        b.append("accessToken=");
        b.append(this.accessToken);
        b.append(", ");
        b.append("saml2Token=");
        b.append(this.saml2Token);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
