package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Operating System version range.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "lowestVersion", 
    "highestVersion"})
@JsonInclude(Include.NON_NULL)
public class OperatingSystemVersionRange implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("lowestVersion")
    protected String lowestVersion;

    @JsonProperty("highestVersion")
    protected String highestVersion;

    protected OperatingSystemVersionRange() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.operatingSystemVersionRange";
    }

    /**
     * <i>“The description of this range (e.g. Valid 1702 builds)”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The description of this range (e.g. Valid 1702 builds)”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public OperatingSystemVersionRange withDescription(String description) {
        OperatingSystemVersionRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.operatingSystemVersionRange");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The lowest inclusive version that this range contains.”</i>
     * 
     * @return property lowestVersion
     */
    @Property(name="lowestVersion")
    @JsonIgnore
    public Optional<String> getLowestVersion() {
        return Optional.ofNullable(lowestVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lowestVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The lowest inclusive version that this range contains.”</i>
     * 
     * @param lowestVersion
     *            new value of {@code lowestVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lowestVersion} field changed
     */
    public OperatingSystemVersionRange withLowestVersion(String lowestVersion) {
        OperatingSystemVersionRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.operatingSystemVersionRange");
        _x.lowestVersion = lowestVersion;
        return _x;
    }

    /**
     * <i>“The highest inclusive version that this range contains.”</i>
     * 
     * @return property highestVersion
     */
    @Property(name="highestVersion")
    @JsonIgnore
    public Optional<String> getHighestVersion() {
        return Optional.ofNullable(highestVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code highestVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The highest inclusive version that this range contains.”</i>
     * 
     * @param highestVersion
     *            new value of {@code highestVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code highestVersion} field changed
     */
    public OperatingSystemVersionRange withHighestVersion(String highestVersion) {
        OperatingSystemVersionRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.operatingSystemVersionRange");
        _x.highestVersion = highestVersion;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private String lowestVersion;
        private String highestVersion;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The description of this range (e.g. Valid 1702 builds)”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The lowest inclusive version that this range contains.”</i>
         * 
         * @param lowestVersion
         *            value of {@code lowestVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lowestVersion(String lowestVersion) {
            this.lowestVersion = lowestVersion;
            this.changedFields = changedFields.add("lowestVersion");
            return this;
        }

        /**
         * <i>“The highest inclusive version that this range contains.”</i>
         * 
         * @param highestVersion
         *            value of {@code highestVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder highestVersion(String highestVersion) {
            this.highestVersion = highestVersion;
            this.changedFields = changedFields.add("highestVersion");
            return this;
        }

        public OperatingSystemVersionRange build() {
            OperatingSystemVersionRange _x = new OperatingSystemVersionRange();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.operatingSystemVersionRange";
            _x.description = description;
            _x.lowestVersion = lowestVersion;
            _x.highestVersion = highestVersion;
            return _x;
        }
    }

    private OperatingSystemVersionRange _copy() {
        OperatingSystemVersionRange _x = new OperatingSystemVersionRange();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.description = description;
        _x.lowestVersion = lowestVersion;
        _x.highestVersion = highestVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OperatingSystemVersionRange[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("lowestVersion=");
        b.append(this.lowestVersion);
        b.append(", ");
        b.append("highestVersion=");
        b.append(this.highestVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
