package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.OnenotePatchActionType;
import odata.msgraph.client.beta.enums.OnenotePatchInsertPosition;

@JsonPropertyOrder({
    "@odata.type", 
    "action", 
    "target", 
    "content", 
    "position"})
@JsonInclude(Include.NON_NULL)
public class OnenotePatchContentCommand implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("action")
    protected OnenotePatchActionType action;

    @JsonProperty("target")
    protected String target;

    @JsonProperty("content")
    protected String content;

    @JsonProperty("position")
    protected OnenotePatchInsertPosition position;

    protected OnenotePatchContentCommand() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onenotePatchContentCommand";
    }

    @Property(name="action")
    @JsonIgnore
    public Optional<OnenotePatchActionType> getAction() {
        return Optional.ofNullable(action);
    }

    public OnenotePatchContentCommand withAction(OnenotePatchActionType action) {
        OnenotePatchContentCommand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePatchContentCommand");
        _x.action = action;
        return _x;
    }

    @Property(name="target")
    @JsonIgnore
    public Optional<String> getTarget() {
        return Optional.ofNullable(target);
    }

    public OnenotePatchContentCommand withTarget(String target) {
        OnenotePatchContentCommand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePatchContentCommand");
        _x.target = target;
        return _x;
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<String> getContent() {
        return Optional.ofNullable(content);
    }

    public OnenotePatchContentCommand withContent(String content) {
        OnenotePatchContentCommand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePatchContentCommand");
        _x.content = content;
        return _x;
    }

    @Property(name="position")
    @JsonIgnore
    public Optional<OnenotePatchInsertPosition> getPosition() {
        return Optional.ofNullable(position);
    }

    public OnenotePatchContentCommand withPosition(OnenotePatchInsertPosition position) {
        OnenotePatchContentCommand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePatchContentCommand");
        _x.position = position;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OnenotePatchActionType action;
        private String target;
        private String content;
        private OnenotePatchInsertPosition position;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder action(OnenotePatchActionType action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder position(OnenotePatchInsertPosition position) {
            this.position = position;
            this.changedFields = changedFields.add("position");
            return this;
        }

        public OnenotePatchContentCommand build() {
            OnenotePatchContentCommand _x = new OnenotePatchContentCommand();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.onenotePatchContentCommand";
            _x.action = action;
            _x.target = target;
            _x.content = content;
            _x.position = position;
            return _x;
        }
    }

    private OnenotePatchContentCommand _copy() {
        OnenotePatchContentCommand _x = new OnenotePatchContentCommand();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.action = action;
        _x.target = target;
        _x.content = content;
        _x.position = position;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnenotePatchContentCommand[");
        b.append("action=");
        b.append(this.action);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("position=");
        b.append(this.position);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
