package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "previewImageUrl"})
@JsonInclude(Include.NON_NULL)
public class OnenotePagePreviewLinks implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("previewImageUrl")
    protected ExternalLink previewImageUrl;

    protected OnenotePagePreviewLinks() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onenotePagePreviewLinks";
    }

    @Property(name="previewImageUrl")
    @JsonIgnore
    public Optional<ExternalLink> getPreviewImageUrl() {
        return Optional.ofNullable(previewImageUrl);
    }

    public OnenotePagePreviewLinks withPreviewImageUrl(ExternalLink previewImageUrl) {
        OnenotePagePreviewLinks _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePagePreviewLinks");
        _x.previewImageUrl = previewImageUrl;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ExternalLink previewImageUrl;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder previewImageUrl(ExternalLink previewImageUrl) {
            this.previewImageUrl = previewImageUrl;
            this.changedFields = changedFields.add("previewImageUrl");
            return this;
        }

        public OnenotePagePreviewLinks build() {
            OnenotePagePreviewLinks _x = new OnenotePagePreviewLinks();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.onenotePagePreviewLinks";
            _x.previewImageUrl = previewImageUrl;
            return _x;
        }
    }

    private OnenotePagePreviewLinks _copy() {
        OnenotePagePreviewLinks _x = new OnenotePagePreviewLinks();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.previewImageUrl = previewImageUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnenotePagePreviewLinks[");
        b.append("previewImageUrl=");
        b.append(this.previewImageUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
