package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "previewText", 
    "links"})
@JsonInclude(Include.NON_NULL)
public class OnenotePagePreview implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("previewText")
    protected String previewText;

    @JsonProperty("links")
    protected OnenotePagePreviewLinks links;

    protected OnenotePagePreview() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onenotePagePreview";
    }

    @Property(name="previewText")
    @JsonIgnore
    public Optional<String> getPreviewText() {
        return Optional.ofNullable(previewText);
    }

    public OnenotePagePreview withPreviewText(String previewText) {
        OnenotePagePreview _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePagePreview");
        _x.previewText = previewText;
        return _x;
    }

    @Property(name="links")
    @JsonIgnore
    public Optional<OnenotePagePreviewLinks> getLinks() {
        return Optional.ofNullable(links);
    }

    public OnenotePagePreview withLinks(OnenotePagePreviewLinks links) {
        OnenotePagePreview _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onenotePagePreview");
        _x.links = links;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String previewText;
        private OnenotePagePreviewLinks links;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder previewText(String previewText) {
            this.previewText = previewText;
            this.changedFields = changedFields.add("previewText");
            return this;
        }

        public Builder links(OnenotePagePreviewLinks links) {
            this.links = links;
            this.changedFields = changedFields.add("links");
            return this;
        }

        public OnenotePagePreview build() {
            OnenotePagePreview _x = new OnenotePagePreview();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.onenotePagePreview";
            _x.previewText = previewText;
            _x.links = links;
            return _x;
        }
    }

    private OnenotePagePreview _copy() {
        OnenotePagePreview _x = new OnenotePagePreview();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.previewText = previewText;
        _x.links = links;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnenotePagePreview[");
        b.append("previewText=");
        b.append(this.previewText);
        b.append(", ");
        b.append("links=");
        b.append(this.links);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
